/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.common.data;

import com.nyiso.common.data.Command;
import com.nyiso.common.data.DataSet;
import com.nyiso.common.data.DataSetInterface;
import com.nyiso.common.data.to.UserTO;
import com.nyiso.common.naming.DataSourceLocator;
import com.nyiso.common.utility.ExceptionWrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.NamingException;
import oracle.jdbc.driver.OracleCallableStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JdbcCommand
implements Command {
    private String dataSourceName = "default";
    private static final String NO_USER = "no user set";
    private Connection connection = null;
    private UserTO user = null;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    protected String getDataSourceName() {
        return this.dataSourceName;
    }

    protected void setDataSourceName(String newValue) {
        this.dataSourceName = newValue;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection newValue) {
        this.connection = newValue;
    }

    public UserTO getUser() {
        return this.user;
    }

    public void setUser(UserTO newValue) {
        this.user = newValue;
    }

    protected void logUserSql(String query) {
        if (this.log.isDebugEnabled()) {
            StringBuffer userLog = new StringBuffer();
            userLog.append("[");
            userLog.append(this.getClass().getName());
            userLog.append("] ");
            userLog.append("[");
            if (this.user != null) {
                userLog.append(this.user.getUserName());
            } else {
                userLog.append(NO_USER);
            }
            userLog.append("] ");
            userLog.append(query);
            this.log.debug((Object)userLog);
        }
    }

    public abstract void execute() throws ExceptionWrapper;

    protected void open() throws NamingException, SQLException {
        if (this.connection != null) {
            return;
        }
        DataSourceLocator locator = DataSourceLocator.getInstance();
        this.connection = locator.getConnection(this.dataSourceName);
    }

    protected void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        this.connection.close();
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSetInterface retrieveData(PreparedStatement statement) throws SQLException {
        DataSet relations = new DataSet();
        ResultSet source = null;
        try {
            source = statement.executeQuery();
            ResultSetMetaData sourceMetaData = source.getMetaData();
            int columnCount = sourceMetaData.getColumnCount();
            String[] attributeNames = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                attributeNames[i - 1] = sourceMetaData.getColumnName(i);
            }
            relations.setAttributeNames(attributeNames);
            ArrayList<Object[]> tempRecords = new ArrayList<Object[]>();
            while (source.next()) {
                Object[] currentRecord = new Object[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    currentRecord[i - 1] = source.getObject(i);
                }
                tempRecords.add(currentRecord);
            }
            int rowCount = tempRecords.size();
            Object[][] dataSet = new Object[rowCount][columnCount];
            Object[] tempRecordArray = tempRecords.toArray();
            for (int i = 0; i < rowCount; ++i) {
                dataSet[i] = (Object[])tempRecordArray[i];
            }
            relations.setDataSource(dataSet);
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
        return relations;
    }

    protected DataSetInterface retrieveData(String query) throws ExceptionWrapper {
        PreparedStatement stmt = null;
        DataSetInterface dataSet = null;
        long startMillis = System.currentTimeMillis();
        try {
            this.open();
            stmt = this.connection.prepareStatement(query);
            dataSet = this.retrieveData(stmt);
        }
        catch (SQLException sqle) {
            this.log.error((Object)"caught SQLException", (Throwable)sqle);
            throw new ExceptionWrapper((Exception)sqle);
        }
        catch (NamingException ne) {
            this.log.error((Object)"caught NamingException", (Throwable)ne);
            throw new ExceptionWrapper((Exception)ne);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.close();
                long elapsedMillis = System.currentTimeMillis() - startMillis;
                this.logUserSql("Elapsed time = " + elapsedMillis + "---" + query);
            }
            catch (SQLException sqle) {
                this.log.error((Object)"caught SQLException", (Throwable)sqle);
                throw new ExceptionWrapper((Exception)sqle);
            }
        }
        return dataSet;
    }

    protected DataSetInterface retrieveData(String call, Object position) throws ExceptionWrapper {
        ResultSet source = null;
        ResultSetMetaData sourceMetaData = null;
        String[] attributeNames = null;
        Object[][] dataSet = null;
        Statement stmt = null;
        DataSet relations = new DataSet();
        int columnCount = 0;
        int rowCount = 0;
        int cursorPosition = Integer.parseInt(position.toString());
        try {
            int i;
            this.open();
            ArrayList<Object[]> tempRecords = new ArrayList<Object[]>();
            Object[] currentRecord = null;
            this.logUserSql(call);
            stmt = this.connection.prepareCall(call);
            stmt.registerOutParameter(cursorPosition, -10);
            source = stmt.executeQuery();
            source = ((OracleCallableStatement)stmt).getCursor(cursorPosition);
            sourceMetaData = source.getMetaData();
            columnCount = sourceMetaData.getColumnCount();
            attributeNames = new String[columnCount];
            for (i = 1; i <= columnCount; ++i) {
                attributeNames[i - 1] = sourceMetaData.getColumnName(i);
            }
            relations.setAttributeNames(attributeNames);
            while (source.next()) {
                currentRecord = new Object[columnCount];
                for (i = 1; i <= columnCount; ++i) {
                    currentRecord[i - 1] = source.getObject(i);
                }
                tempRecords.add(currentRecord);
            }
            rowCount = tempRecords.size();
            dataSet = new Object[rowCount][columnCount];
            Object[] tempRecordArray = tempRecords.toArray();
            for (int i2 = 0; i2 < rowCount; ++i2) {
                dataSet[i2] = (Object[])tempRecordArray[i2];
            }
            relations.setDataSource(dataSet);
            DataSet dataSet2 = relations;
            return dataSet2;
        }
        catch (SQLException se) {
            throw new ExceptionWrapper((Exception)se);
        }
        catch (NamingException ne) {
            throw new ExceptionWrapper((Exception)ne);
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                this.close();
            }
            catch (SQLException e) {
                throw new ExceptionWrapper((Exception)e);
            }
        }
    }

    protected int updateData(String query) throws ExceptionWrapper {
        Statement stmt = null;
        int returnRows = 0;
        try {
            this.open();
            this.logUserSql(query);
            stmt = this.connection.prepareStatement(query);
            returnRows = stmt.executeUpdate();
            this.connection.commit();
            int n = returnRows;
            return n;
        }
        catch (SQLException se) {
            throw new ExceptionWrapper((Exception)se);
        }
        catch (NamingException ne) {
            throw new ExceptionWrapper((Exception)ne);
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.close();
            }
            catch (SQLException e) {
                throw new ExceptionWrapper((Exception)e);
            }
        }
    }

    protected int updateData(String query, Object param) throws ExceptionWrapper {
        Statement stmt = null;
        try {
            this.open();
            this.logUserSql(query);
            stmt = this.connection.prepareCall(query);
            boolean result = stmt.execute();
            int returnVal = 0;
            if (!result) {
                returnVal = -1;
            }
            int n = returnVal;
            return n;
        }
        catch (SQLException se) {
            throw new ExceptionWrapper((Exception)se);
        }
        catch (NamingException ne) {
            throw new ExceptionWrapper((Exception)ne);
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.close();
            }
            catch (SQLException e) {
                throw new ExceptionWrapper((Exception)e);
            }
        }
    }
}

