/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.common.data;

import com.nyiso.common.data.Command;
import com.nyiso.common.data.DataSetInterface;
import com.nyiso.common.data.LdapDataSet;
import com.nyiso.common.data.pool.DataAccessFactory;
import com.nyiso.common.utility.ExceptionWrapper;
import java.io.IOException;
import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public abstract class LdapCommand
implements Command {
    protected GenericObjectPool ldapPool = null;
    protected DirContext directory = null;
    private Log log = LogFactory.getLog((Class)(class$com$nyiso$common$data$LdapCommand == null ? (class$com$nyiso$common$data$LdapCommand = LdapCommand.class$("com.nyiso.common.data.LdapCommand")) : class$com$nyiso$common$data$LdapCommand));
    static /* synthetic */ Class class$com$nyiso$common$data$LdapCommand;

    public abstract void execute() throws ExceptionWrapper;

    protected void open() throws IOException, Exception {
        if (this.directory != null) {
            return;
        }
        this.log.debug((Object)"getting DataAccessFactory...");
        DataAccessFactory dataFactory = DataAccessFactory.getInstance();
        this.log.debug((Object)"getting Ldap Pool...");
        this.ldapPool = dataFactory.getLdapPool();
        this.log.debug((Object)("getting DirContext..." + new Boolean(this.ldapPool == null).toString()));
        this.directory = (DirContext)this.ldapPool.borrowObject();
        this.log.debug((Object)("Status: " + new Boolean(this.directory == null).toString()));
    }

    protected void close() throws ExceptionWrapper {
        if (this.directory == null) {
            return;
        }
        try {
            this.ldapPool.returnObject((Object)this.directory);
            this.directory = null;
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    public DataSetInterface retrieveData(String baseDn, String query, SearchControls controls) throws ExceptionWrapper {
        this.log.debug((Object)"in retrieve...");
        NamingEnumeration<SearchResult> results = null;
        ArrayList<Object[]> tempList = new ArrayList<Object[]>();
        Object[][] dataMatrix = null;
        LdapDataSet returnData = new LdapDataSet();
        Attributes current = null;
        this.log.debug((Object)"setting columns...");
        String[] columns = controls.getReturningAttributes();
        returnData.setAttributeNames(columns);
        try {
            int i;
            this.log.debug((Object)"opening connection...");
            this.open();
            this.log.debug((Object)baseDn);
            results = this.directory.search(baseDn, query, controls);
            while (results.hasMore()) {
                this.log.debug((Object)"next result");
                current = results.next().getAttributes();
                Object[] rowTemp = new Object[columns.length];
                for (i = 0; i < columns.length; ++i) {
                    this.log.debug((Object)current.get(columns[i]).toString());
                    rowTemp[i] = current.get(columns[i]);
                }
                tempList.add(rowTemp);
            }
            dataMatrix = new Object[tempList.size()][columns.length];
            Object[] tempRecordArray = tempList.toArray();
            for (i = 0; i < tempRecordArray.length; ++i) {
                dataMatrix[i] = (Object[])tempRecordArray[i];
            }
            returnData.setDataSource(dataMatrix);
            LdapDataSet ldapDataSet = returnData;
            return ldapDataSet;
        }
        catch (NamingException e) {
            throw new ExceptionWrapper((Exception)e);
        }
        catch (IOException e) {
            throw new ExceptionWrapper((Exception)e);
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
        finally {
            try {
                this.close();
                this.log.debug((Object)"*** CLOSED LDAP DIRCONTEXT ***");
            }
            catch (Exception e) {
                throw new ExceptionWrapper(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

