/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.common.data.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.pool.PoolableObjectFactory;

public class DatabaseConnectionFactory
implements PoolableObjectFactory {
    private boolean classLoaded = false;
    private String databaseUrl;
    private String userName;
    private String password;
    private Map params;

    public DatabaseConnectionFactory() {
    }

    public DatabaseConnectionFactory(Map parameters) {
        this.params = parameters;
    }

    public Object makeObject() throws Exception {
        if (!this.classLoaded) {
            Class.forName(this.params.get("providerClass").toString());
            this.databaseUrl = this.params.get("resourceUri").toString();
            this.userName = this.params.get("account").toString();
            this.password = this.params.get("key").toString();
            this.classLoaded = true;
        }
        return DriverManager.getConnection(this.databaseUrl, this.userName, this.password);
    }

    public void destroyObject(Object obj) throws Exception {
        Connection conn = (Connection)obj;
        conn.close();
        conn = null;
    }

    public boolean validateObject(Object obj) {
        Connection conn = (Connection)obj;
        boolean returnValue = true;
        try {
            if (conn.isClosed()) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            returnValue = false;
        }
        return returnValue;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void passivateObject(Object obj) throws Exception {
    }
}

