/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.bidding;

public enum BidStatus {
    WAITING_VALIDATION(3, "WAITING VALIDATION"),
    VALIDATION_FAILED(4, "VALIDATION FAILED"),
    WAITING_CONFIRMATION(5, "WAITING CONFIRMATION"),
    VALIDATION_PASSED(6, "VALIDATION PASSED"),
    EVALUATING(7, "EVALUATING"),
    BID_REJECTED(8, "BID REJECTED"),
    ADVISORY_REJECTED(9, "ADVISORY REJECTED"),
    BID_ACCEPTED(10, "BID ACCEPTED"),
    ADVISORY_ACCEPTED(11, "ADVISORY ACCEPTED"),
    MODIFIED(12, "MODIFIED"),
    PRE_SCHED_QUEUED(21, "PRE SCHED QUEUED"),
    PRE_SCHED_REJECTED(22, "PRE SCHED REJECTED"),
    PRE_SCHED_CONFIRMED(23, "PRE SCHED CONFIRMED"),
    PRE_SCHED_MARKET_CLOSED(24, "PRE SCH  MRKT CLOSED");

    private int statusId;
    private String statusDescription;

    private BidStatus(int statusId, String statusDescription) {
        this.statusId = statusId;
        this.statusDescription = statusDescription;
    }

    public static BidStatus getStatusFromDescription(String desc) throws IllegalArgumentException {
        for (BidStatus bidStatus : BidStatus.values()) {
            if (!bidStatus.getStatusDescription().equalsIgnoreCase(desc)) continue;
            return bidStatus;
        }
        throw new IllegalArgumentException("No bid status for: " + desc);
    }

    public static BidStatus getBidStatusById(int id) throws IllegalArgumentException {
        for (BidStatus bidStatus : BidStatus.values()) {
            if (bidStatus.getStatusId() != id) continue;
            return bidStatus;
        }
        throw new IllegalArgumentException("Invalid bid status id:" + id);
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BidStatus [");
        if (this.statusDescription != null) {
            builder.append("statusDescription=").append(this.statusDescription).append(", ");
        }
        builder.append("statusId=").append(this.statusId);
        builder.append("[").append(super.toString()).append("]]");
        return builder.toString();
    }
}

