/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.bidding;

public enum EsrManagementMode {
    ISO("I", "ISO"),
    SELF("S", "Self");

    private String id;
    private String description;

    private EsrManagementMode(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public static EsrManagementMode getEsrManagementModeByStrId(String id) {
        for (EsrManagementMode market : EsrManagementMode.values()) {
            if (!market.getId().equals(id)) continue;
            return market;
        }
        throw new IllegalArgumentException("Invalid ESR Management Mode Identifier:" + id);
    }

    public static EsrManagementMode getEsrManagementModeByDescription(String desc) {
        for (EsrManagementMode emm : EsrManagementMode.values()) {
            if (!emm.getDescription().equals(desc)) continue;
            return emm;
        }
        throw new IllegalArgumentException("Invalid ESR Management Mode Description:" + desc);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "EsrManagementMode{id='" + this.id + '\'' + '}';
    }
}

