/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.bidding;

public enum Market {
    ISO_LF(1, "ISO LF"),
    DAM(3, "DAM"),
    HAM(4, "HAM"),
    AVG_SCD(5, "AVG SCD"),
    RTD(6, "RTD"),
    SRE(7, "SRE"),
    OOM(8, "OOM"),
    LRR(9, "LRR"),
    NON_FIRM(20, "NON-FIRM"),
    DAM_CB(30, "DAM-CB"),
    ZONE_MIT(31, "ZONE MIT");

    private String marketDescription;
    private int marketId;

    private Market(int marketId, String marketDescription) {
        this.marketId = marketId;
        this.marketDescription = marketDescription;
    }

    public static Market getMarketByDescription(String desc) throws IllegalArgumentException {
        for (Market market : Market.values()) {
            if (!market.getMarketDescription().equals(desc)) continue;
            return market;
        }
        throw new IllegalArgumentException("Invalid market description:" + desc);
    }

    public static Market getMarketById(int id) throws IllegalArgumentException {
        for (Market market : Market.values()) {
            if (market.getMarketId() != id) continue;
            return market;
        }
        throw new IllegalArgumentException("Invalid market id:" + id);
    }

    public String getMarketDescription() {
        return this.marketDescription;
    }

    public int getMarketId() {
        return this.marketId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Market [");
        if (this.marketDescription != null) {
            builder.append("marketDescription=").append(this.marketDescription);
        }
        builder.append("[").append(super.toString()).append("]]");
        return builder.toString();
    }
}

