/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.generator;

import java.io.Serializable;

public class GeneratorBase
implements Serializable {
    private static final long serialVersionUID = -1485217900568503200L;
    private Integer generatorId;
    private String generatorName;
    private String stationName;
    private String voltageClass;
    private String displayName;
    private Integer ptid;
    private Boolean active;

    public GeneratorBase() {
    }

    public GeneratorBase(Integer ptid) {
        this.ptid = ptid;
    }

    public GeneratorBase(Integer ptid, String stationName, String voltageClass, String genName) {
        this.ptid = ptid;
        this.stationName = stationName;
        this.voltageClass = voltageClass;
        this.generatorName = genName;
    }

    public Integer getGeneratorId() {
        return this.generatorId;
    }

    public void setGeneratorId(Integer generatorId) {
        this.generatorId = generatorId;
    }

    public String getGeneratorName() {
        return this.generatorName;
    }

    public void setGeneratorName(String generatorName) {
        this.generatorName = generatorName;
    }

    public Integer getPtid() {
        return this.ptid;
    }

    public void setPtid(Integer ptid) {
        this.ptid = ptid;
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getVoltageClass() {
        return this.voltageClass;
    }

    public void setVoltageClass(String voltageClass) {
        this.voltageClass = voltageClass;
    }

    public String getDisplayName() {
        String genName;
        String stationNm = this.stationName != null ? this.stationName : "";
        String voltageCls = this.voltageClass != null ? this.voltageClass : "";
        String string = genName = this.generatorName != null ? this.generatorName : "";
        if (stationNm.length() == 0 && voltageCls.length() == 0 && genName.length() == 0) {
            return null;
        }
        this.displayName = stationNm.concat("_").concat(voltageCls).concat("_").concat(genName);
        return this.displayName;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active == null ? 0 : this.active.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.generatorId == null ? 0 : this.generatorId.hashCode());
        result = 31 * result + (this.generatorName == null ? 0 : this.generatorName.hashCode());
        result = 31 * result + (this.ptid == null ? 0 : this.ptid.hashCode());
        result = 31 * result + (this.stationName == null ? 0 : this.stationName.hashCode());
        result = 31 * result + (this.voltageClass == null ? 0 : this.voltageClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneratorBase other = (GeneratorBase)obj;
        if (this.active == null ? other.active != null : !this.active.equals(other.active)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.generatorId == null ? other.generatorId != null : !this.generatorId.equals(other.generatorId)) {
            return false;
        }
        if (this.generatorName == null ? other.generatorName != null : !this.generatorName.equals(other.generatorName)) {
            return false;
        }
        if (this.ptid == null ? other.ptid != null : !this.ptid.equals(other.ptid)) {
            return false;
        }
        if (this.stationName == null ? other.stationName != null : !this.stationName.equals(other.stationName)) {
            return false;
        }
        return !(this.voltageClass == null ? other.voltageClass != null : !this.voltageClass.equals(other.voltageClass));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratorBase [");
        if (this.generatorId != null) {
            builder.append("generatorId=").append(this.generatorId).append(", ");
        }
        if (this.generatorName != null) {
            builder.append("generatorName=").append(this.generatorName).append(", ");
        }
        if (this.stationName != null) {
            builder.append("stationName=").append(this.stationName).append(", ");
        }
        if (this.voltageClass != null) {
            builder.append("voltageClass=").append(this.voltageClass).append(", ");
        }
        if (this.displayName != null) {
            builder.append("displayName=").append(this.displayName).append(", ");
        }
        if (this.ptid != null) {
            builder.append("ptid=").append(this.ptid).append(", ");
        }
        if (this.active != null) {
            builder.append("active=").append(this.active);
        }
        builder.append("[").append(super.toString()).append("]]");
        return builder.toString();
    }
}

