/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.identity;

public enum OrganizationType {
    ADMINISTRATIVE(1, "ADMINISTRATIVE"),
    AFFILIATE(10, "AFFILIATED ENTITY"),
    ALLOCATED_ADJUSTMENT(7, "ALLOCATED ADJUSTMENT"),
    GUEST(2, "GUEST"),
    INTERFACE(4, "INTERFACE"),
    METER_AUTHORITY(8, "METER AUTHORITY"),
    NYISO_CUSTOMER(3, "NYISO CUSTOMER"),
    NYISO_DISPATCHER(5, "NYISO DISPATCHER"),
    NYISO_OBSERVER(6, "NYISO OBSERVER"),
    PRIVILEGES_ONLY(9, "PRIVILEGES ONLY");

    private int orgTypeId;
    private String orgTypeDescription;

    private OrganizationType(int id, String description) {
        this.orgTypeId = id;
        this.orgTypeDescription = description;
    }

    public static OrganizationType getOrgTypeByDescription(String desc) {
        for (OrganizationType ot : OrganizationType.values()) {
            if (!ot.getOrgTypeDescription().equals(desc)) continue;
            return ot;
        }
        throw new IllegalArgumentException("Unrecognized organization type: " + desc);
    }

    public static OrganizationType getOrgTypeById(int orgTypeId) {
        for (OrganizationType organizationType : OrganizationType.values()) {
            if (organizationType.getOrgTypeId() != orgTypeId) continue;
            return organizationType;
        }
        throw new IllegalArgumentException("No organization type matching: " + orgTypeId);
    }

    public int getOrgTypeId() {
        return this.orgTypeId;
    }

    public String getOrgTypeDescription() {
        return this.orgTypeDescription;
    }
}

