/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.load;

import com.nyiso.marketplace.businessobjects.load.LoadBase;
import com.nyiso.marketplace.businessobjects.loadservingentity.LoadServingEntity;
import com.nyiso.marketplace.businessobjects.subzone.Subzone;
import com.nyiso.marketplace.common.util.LoadBusConcatNameParser;
import java.math.BigDecimal;
import java.util.Calendar;

public class Load
extends LoadBase
implements Cloneable {
    private static final long serialVersionUID = 5517369536878491918L;
    private Boolean energyBidQualified;
    private Boolean priceCapQualified;
    private Boolean intrruptable10Minute;
    private Boolean intrruptable30Minute;
    private Boolean meterQualified;
    private String edcArea;
    private String log;
    private LoadServingEntity lse;
    private Subzone subzone;
    private Boolean externalSink;
    private Boolean nyisoReferenceBus;
    private Boolean proxyLoadBus;
    private BigDecimal priceCapLimitMw;
    private BigDecimal fixedLimitMw;
    private BigDecimal forecastLimitMw;
    private Calendar updateTime;
    private String updateAdmin;

    public Load() {
    }

    public Load(LoadBase loadBase) {
        this.setPtid(loadBase.getPtid());
        this.setStationName(loadBase.getStationName());
        this.setVoltageClass(loadBase.getVoltageClass());
        this.setLoadName(loadBase.getLoadName());
        this.setLoadId(loadBase.getLoadId());
        this.setLoadType(loadBase.getLoadType());
        this.setLseBusEndDate(loadBase.getLseBusEndDate());
        this.setLseBusStateDate(loadBase.getLseBusStateDate());
    }

    public Load(Integer ptid, String stationName, String voltageClass, String loadName) {
        this.setPtid(ptid);
        this.setStationName(stationName);
        this.setVoltageClass(voltageClass);
        this.setLoadName(loadName);
    }

    public Load(Integer ptid) {
        this.setPtid(ptid);
    }

    public Load(String displayName, Integer ptid) {
        if (displayName != null) {
            LoadBase loadBase = LoadBusConcatNameParser.parserLoadBusConcatName(displayName);
            this.setStationName(loadBase.getStationName());
            this.setVoltageClass(loadBase.getVoltageClass());
            this.setLoadName(loadBase.getLoadName());
        }
        this.setPtid(ptid);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("Load clone failed.", cnse);
        }
    }

    public Boolean getEnergyBidQualified() {
        return this.energyBidQualified;
    }

    public void setEnergyBidQualified(Boolean energyBidQualified) {
        this.energyBidQualified = energyBidQualified;
    }

    public Boolean getIntrruptable10Minute() {
        return this.intrruptable10Minute;
    }

    public void setIntrruptable10Minute(Boolean intrruptable10Minute) {
        this.intrruptable10Minute = intrruptable10Minute;
    }

    public Boolean getIntrruptable30Minute() {
        return this.intrruptable30Minute;
    }

    public void setIntrruptable30Minute(Boolean intrruptable30Minute) {
        this.intrruptable30Minute = intrruptable30Minute;
    }

    public Boolean getPriceCapQualified() {
        return this.priceCapQualified;
    }

    public void setPriceCapQualified(Boolean priceCapQualified) {
        this.priceCapQualified = priceCapQualified;
    }

    public String getEdcArea() {
        return this.edcArea;
    }

    public void setEdcArea(String edcArea) {
        this.edcArea = edcArea;
    }

    public Boolean getMeterQualified() {
        return this.meterQualified;
    }

    public void setMeterQualified(Boolean meterQualified) {
        this.meterQualified = meterQualified;
    }

    public LoadServingEntity getLse() {
        return this.lse;
    }

    public void setLse(LoadServingEntity lse) {
        this.lse = lse;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        if (log != null) {
            this.log = log.trim();
        }
    }

    public Subzone getSubzone() {
        return this.subzone;
    }

    public void setSubzone(Subzone subzone) {
        this.subzone = subzone;
    }

    public Boolean getExternalSink() {
        return this.externalSink;
    }

    public void setExternalSink(Boolean externalSink) {
        this.externalSink = externalSink;
    }

    public Boolean getNyisoReferenceBus() {
        return this.nyisoReferenceBus;
    }

    public void setNyisoReferenceBus(Boolean nyisoReferenceBus) {
        this.nyisoReferenceBus = nyisoReferenceBus;
    }

    public Boolean getProxyLoadBus() {
        return this.proxyLoadBus;
    }

    public void setProxyLoadBus(Boolean proxyLoadBus) {
        this.proxyLoadBus = proxyLoadBus;
    }

    public BigDecimal getPriceCapLimitMw() {
        return this.priceCapLimitMw;
    }

    public void setPriceCapLimitMw(BigDecimal priceCapLimitMw) {
        this.priceCapLimitMw = priceCapLimitMw;
    }

    public BigDecimal getFixedLimitMw() {
        return this.fixedLimitMw;
    }

    public void setFixedLimitMw(BigDecimal fixedLimitMw) {
        this.fixedLimitMw = fixedLimitMw;
    }

    public BigDecimal getForecastLimitMw() {
        return this.forecastLimitMw;
    }

    public void setForecastLimitMw(BigDecimal forecastLimitMw) {
        this.forecastLimitMw = forecastLimitMw;
    }

    public Calendar getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Calendar updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateAdmin() {
        return this.updateAdmin;
    }

    public void setUpdateAdmin(String updateAdmin) {
        this.updateAdmin = updateAdmin;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Load [");
        if (this.energyBidQualified != null) {
            builder.append("energyBidQualified=").append(this.energyBidQualified).append(", ");
        }
        if (this.priceCapQualified != null) {
            builder.append("priceCapQualified=").append(this.priceCapQualified).append(", ");
        }
        if (this.intrruptable10Minute != null) {
            builder.append("intrruptable10Minute=").append(this.intrruptable10Minute).append(", ");
        }
        if (this.intrruptable30Minute != null) {
            builder.append("intrruptable30Minute=").append(this.intrruptable30Minute).append(", ");
        }
        if (this.meterQualified != null) {
            builder.append("meterQualified=").append(this.meterQualified).append(", ");
        }
        if (this.edcArea != null) {
            builder.append("edcArea=").append(this.edcArea).append(", ");
        }
        if (this.log != null) {
            builder.append("log=").append(this.log).append(", ");
        }
        if (this.lse != null) {
            builder.append("lse=").append(this.lse).append(", ");
        }
        if (this.subzone != null) {
            builder.append("subzone=").append(this.subzone).append(", ");
        }
        if (this.externalSink != null) {
            builder.append("externalSink=").append(this.externalSink).append(", ");
        }
        if (this.nyisoReferenceBus != null) {
            builder.append("nyisoReferenceBus=").append(this.nyisoReferenceBus).append(", ");
        }
        if (this.proxyLoadBus != null) {
            builder.append("proxyLoadBus=").append(this.proxyLoadBus).append(", ");
        }
        if (this.priceCapLimitMw != null) {
            builder.append("priceCapLimitMw=").append(this.priceCapLimitMw).append(", ");
        }
        if (this.fixedLimitMw != null) {
            builder.append("fixedLimitMw=").append(this.fixedLimitMw).append(", ");
        }
        if (this.forecastLimitMw != null) {
            builder.append("forecastLimitMw=").append(this.forecastLimitMw).append(", ");
        }
        if (this.updateTime != null) {
            builder.append("updateTime=").append(this.updateTime).append(", ");
        }
        if (this.updateAdmin != null) {
            builder.append("updateAdmin=").append(this.updateAdmin);
        }
        builder.append("[").append(super.toString()).append("]]");
        return builder.toString();
    }
}

