/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.load;

public enum LoadType {
    METERING_POINT(6, "METERING POINT"),
    PROXY(4, "PROXY"),
    REAL_LOAD(1, "REAL LOAD"),
    STATION_SERVICE_LOAD(5, "STATION SERVICE LOAD"),
    TRADING_HUB(7, "TRADING HUB"),
    VIRTUAL_LOAD(2, "VIRTUAL LOAD"),
    VIRTUAL_SUPPLY(3, "VIRTUAL SUPPLY");

    private int loadTypeId;
    private String loadTypeDescription;

    private LoadType(int id, String description) {
        this.loadTypeId = id;
        this.loadTypeDescription = description;
    }

    public static LoadType getLoadTypeFromDescription(String description) {
        for (LoadType loadType : LoadType.values()) {
            if (!loadType.getLoadTypeDescription().equalsIgnoreCase(description)) continue;
            return loadType;
        }
        throw new IllegalArgumentException("No load type matching: " + description);
    }

    public static LoadType getLoadTypeFromId(int loadTypeId) {
        for (LoadType loadType : LoadType.values()) {
            if (loadType.getLoadTypeId() != loadTypeId) continue;
            return loadType;
        }
        throw new IllegalArgumentException("No load type matching: " + loadTypeId);
    }

    public int getLoadTypeId() {
        return this.loadTypeId;
    }

    public String getLoadTypeDescription() {
        return this.loadTypeDescription;
    }
}

