/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.exception;

import com.nyiso.marketplace.common.config.ConfigurationLoader;
import com.nyiso.marketplace.common.exception.ErrorMessagesCommon;
import com.nyiso.marketplace.common.exception.MarketplaceError;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class AdminErrorMessagesCommon
extends ErrorMessagesCommon {
    private static final String CONFIG_FILE = "/admin/errormessages/commonadminerrormessages.properties";
    private static final PropertiesConfiguration CONFIG = ConfigurationLoader.loadPropertiesConfiguration("/admin/errormessages/commonadminerrormessages.properties");

    public static final MarketplaceError getAdministratorNoLongerExistsMessage(Integer admId) {
        String errorMessage = CONFIG.getString("administrator.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, admId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getAttributeNoLongerExistsMessage(Integer attributeId) {
        String errorMessage = CONFIG.getString("attribute.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, attributeId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getAttributeRelationshipValueProhibitedMessage() {
        String errorMessage = CONFIG.getString("attribute.relationship.value.prohibited");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getAttributeRelationshipValueInvalidMessage(List<String> validAttributeValues) {
        String errorMessage = CONFIG.getString("attribute.relationship.value.invalid");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, StringUtils.join(validAttributeValues, (String)", "));
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getBusNoLongerExistsMessage(Integer busId) {
        String errorMessage = CONFIG.getString("bus.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, busId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getEndDateNotBeforeExistingEndDateMessage() {
        String errorMessage = CONFIG.getString("end.date.not.before.existing.end.date");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getGeneratorNoLongerExistsMessage(Integer generatorId) {
        String errorMessage = CONFIG.getString("generator.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, generatorId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getGeneratorNotActiveMessage() {
        String errorMessage = CONFIG.getString("generator.not.active");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getLoadServingEntityNoLongerExistsMessage(Integer lseId) {
        String errorMessage = CONFIG.getString("load.serving.entity.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, lseId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getLoadServingEntityNotActiveMessage() {
        String errorMessage = CONFIG.getString("load.serving.entity.not.active");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getMeterAuthorityRelationshipNotQualifiedMeterAuthorityMessage() {
        String errorMessage = CONFIG.getString("meter.authority.relationship.not.qualified.meter.authority");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getOnlyEndDateCanBeUpdatedMessage() {
        String errorMessage = CONFIG.getString("only.end.date.can.be.updated");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getOrganizationNoLongerExistsMessage(Integer orgId) {
        String errorMessage = CONFIG.getString("organization.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, orgId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getOrganizationNotActiveMessage() {
        String errorMessage = CONFIG.getString("organization.not.active");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getParameterNoLongerExistsMessage(Integer parameterId) {
        String errorMessage = CONFIG.getString("parameter.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, parameterId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getPrivilegeNoLongerExistsMessage(Integer privilegeId) {
        String errorMessage = CONFIG.getString("privilege.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, privilegeId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getRelationshipDoesNotExistForDeleteMessage() {
        String errorMessage = CONFIG.getString("relationship.does.not.exist.for.delete");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getSelectedRecordDoesNotExistMessage() {
        String errorMessage = CONFIG.getString("selected.record.does.not.exist");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getSkippedAddressInformationMessage() {
        String errorMessage = CONFIG.getString("skipped.address.information");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getStartDateNotBeforeEndDateMessage() {
        String errorMessage = CONFIG.getString("start.date.not.before.end.date");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getSubmittedDataAlreadyExistsMessage() {
        String errorMessage = CONFIG.getString("submitted.data.already.exists");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getSubzoneNoLongerExistsMessage(Integer subzoneId) {
        String errorMessage = CONFIG.getString("subzone.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, subzoneId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getTieNoLongerExistsMessage(Integer tieId) {
        String errorMessage = CONFIG.getString("tie.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, tieId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getUsernameIsInvalidMessage() {
        String errorMessage = CONFIG.getString("username.is.invalid");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getUserNoLongerExistsMessage(Integer userId) {
        String errorMessage = CONFIG.getString("user.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, userId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getZoneNoLongerExistsMessage(Integer zoneId) {
        String errorMessage = CONFIG.getString("zone.no.longer.exists");
        errorMessage = AdminErrorMessagesCommon.replaceMessageToken(errorMessage, zoneId.toString());
        return new MarketplaceError(null, null, errorMessage);
    }

    public static MarketplaceError getIdentitysynchClientCreateUserError() {
        String errorMessage = CONFIG.getString("identitysynch.client.create.user.error");
        return new MarketplaceError(null, null, errorMessage);
    }

    public static final MarketplaceError getUserContactIsInvalidMessage() {
        String errorMessage = CONFIG.getString("user.contact.is.invalid");
        return new MarketplaceError(null, null, errorMessage);
    }
}

