/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.logging;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class ExtendedPatternParser
extends PatternParser {
    public ExtendedPatternParser(String pattern) {
        super(pattern);
    }

    protected void finalizeConverter(char c) {
        switch (c) {
            case 'P': {
                String pOpt = this.extractOption();
                this.addConverter(new SystemPropertyPatternConverter(this.formattingInfo, pOpt));
                this.currentLiteral.setLength(0);
                break;
            }
            case 'T': {
                this.addConverter(new ThreadPatternConverter(this.formattingInfo));
                this.currentLiteral.setLength(0);
                break;
            }
            default: {
                super.finalizeConverter(c);
            }
        }
    }

    private static class ThreadPatternConverter
    extends PatternConverter {
        ThreadPatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            Thread curThread = Thread.currentThread();
            String threadName = curThread.getName();
            int pos = threadName.indexOf("ExecuteThread");
            if (pos >= 0 && (pos = (threadName = threadName.substring(pos)).indexOf("'")) > 0 && (pos = threadName.indexOf("'", pos + 1)) > 0) {
                return threadName.substring(0, pos + 1);
            }
            Long val2 = curThread.getId();
            return val2.toString();
        }
    }

    private static class SystemPropertyPatternConverter
    extends PatternConverter {
        private String key;

        SystemPropertyPatternConverter(FormattingInfo formattingInfo, String key) {
            super(formattingInfo);
            this.key = key;
        }

        public String convert(LoggingEvent event) {
            String val2 = System.getProperty(this.key);
            if (val2 == null) {
                return "";
            }
            return val2;
        }
    }
}

