/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.util;

import com.nyiso.marketplace.businessobjects.bidding.generator.commitment.UnitCommitment;
import com.nyiso.marketplace.businessobjects.generator.GeneratorAttributeRelationship;
import com.nyiso.marketplace.businessobjects.generator.GeneratorBtmngAttributesStatus;
import com.nyiso.marketplace.businessobjects.generator.GeneratorUnitCommitmentDataStatus;
import com.nyiso.marketplace.common.util.UnitCommitmentParameters;
import java.util.Calendar;
import java.util.List;

public final class BtmngGeneratorUtil {
    public static GeneratorBtmngAttributesStatus getBtmngAttributesStatusToday(List<GeneratorAttributeRelationship> btmGenAttribs) {
        Calendar today = Calendar.getInstance();
        return BtmngGeneratorUtil.getBtmngAttributesStatusForReferenceDate(today, btmGenAttribs);
    }

    private static GeneratorBtmngAttributesStatus getBtmngAttributesStatusForReferenceDate(Calendar referenceDate, List<GeneratorAttributeRelationship> btmGenAttribs) {
        GeneratorBtmngAttributesStatus genBtmngStatus = null;
        if (null != btmGenAttribs) {
            if (btmGenAttribs != null && btmGenAttribs.size() > 0) {
                boolean isGenBtmngToday = false;
                boolean btmngAttributeExistsInFuture = false;
                for (GeneratorAttributeRelationship a : btmGenAttribs) {
                    if (a.getStartDate() != null && a.getStartDate().compareTo(referenceDate) <= 0 && (a.getEndDate() == null || referenceDate.compareTo(a.getEndDate()) <= 0)) {
                        isGenBtmngToday = true;
                        continue;
                    }
                    if (a.getStartDate() == null || a.getStartDate().compareTo(referenceDate) <= 0) continue;
                    btmngAttributeExistsInFuture = true;
                }
                genBtmngStatus = new GeneratorBtmngAttributesStatus(isGenBtmngToday, btmngAttributeExistsInFuture);
            }
        } else {
            genBtmngStatus = new GeneratorBtmngAttributesStatus(false, false);
        }
        return genBtmngStatus;
    }

    public static GeneratorUnitCommitmentDataStatus inspectBtmngUnitCommitmentData(UnitCommitment ucData) {
        return new UnitCommitmentParameters().validateUnitCommitmentData(ucData);
    }

    public static boolean isValidUnitCommitmentParametersState(UnitCommitment uc) {
        return new UnitCommitmentParameters().isValidUnitCommitmentParametersState(uc);
    }
}

