/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.util;

import com.nyiso.marketplace.common.config.JndiValues;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LookupUtility {
    private static final Log LOG = LogFactory.getLog(LookupUtility.class);
    private static final String LOCAL_SUFFIX = "Local";

    private LookupUtility() {
    }

    public static <T> T lookup(Class<T> clazz) throws NamingException {
        String name = LookupUtility.computeJNDIName(clazz, JndiValues.APPLICATION_NAME);
        return LookupUtility.lookup(name, clazz);
    }

    public static <T> T lookup(String jndiName, Class<T> clazz) throws NamingException {
        return LookupUtility.lookup(jndiName, clazz, (Properties)null);
    }

    public static <T> T lookup(Class<T> clazz, String jndiProviderUrl) throws NamingException {
        return LookupUtility.lookup(clazz, jndiProviderUrl, JndiValues.APPLICATION_NAME);
    }

    public static <T> T lookup(Class<T> clazz, String jndiProviderUrl, String applicationName) throws NamingException {
        String name = LookupUtility.computeJNDIName(clazz, applicationName);
        return LookupUtility.lookup(name, clazz, jndiProviderUrl);
    }

    public static <T> T lookup(String jndiName, Class<T> clazz, String jndiProviderUrl) throws NamingException {
        Properties environment = new Properties();
        environment.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        environment.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming.client");
        environment.setProperty("java.naming.provider.url", jndiProviderUrl);
        return LookupUtility.lookup(jndiName, clazz, environment);
    }

    private static <T> T lookup(String jndiName, Class<T> clazz, Properties environment) throws NamingException {
        Object bean = null;
        InitialContext context = null;
        try {
            context = new InitialContext(environment);
            bean = context.lookup(jndiName);
        }
        catch (NamingException ex) {
            LOG.error((Object)("Cannot connect to bean: " + jndiName + " using: " + environment + " Reason: " + ex), (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException ex) {
                LOG.error((Object)("Cannot close InitialContext. Reason: " + ex), (Throwable)ex);
            }
        }
        return clazz.cast(bean);
    }

    private static <T> String computeJNDIName(Class<T> clazz, String applicationName) {
        String name = clazz.getSimpleName();
        if (name.endsWith(LOCAL_SUFFIX)) {
            name = name.substring(0, name.length() - LOCAL_SUFFIX.length());
            name = applicationName + "/" + name + "Bean/local";
        } else {
            name = applicationName + "/" + name + "Bean/remote";
        }
        return name;
    }
}

