/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.util;

import java.math.BigDecimal;

public final class NumberUtil {
    private NumberUtil() {
    }

    public static int getNumberOfDecimalPlaces(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(BigDecimal.valueOf(0L)) == 0) {
            return 0;
        }
        String string = bigDecimal.stripTrailingZeros().toPlainString();
        int index = string.indexOf(46);
        return index < 0 ? 0 : string.length() - index - 1;
    }

    public static boolean exceedsDecimalPlacesThreshold(BigDecimal bd, int threshold) {
        return NumberUtil.getNumberOfDecimalPlaces(bd) > threshold;
    }

    public static boolean containsMoreThanOneDecimalPlaces(BigDecimal bd) {
        return NumberUtil.exceedsDecimalPlacesThreshold(bd, 1);
    }

    public static int getNumberOfDecimalPlaces(Float f) {
        return NumberUtil.getNumberOfDecimalPlaces(new BigDecimal(f.toString()));
    }
}

