/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.util;

import com.nyiso.marketplace.businessobjects.bidding.generator.commitment.NotificationTime;
import com.nyiso.marketplace.businessobjects.bidding.generator.commitment.StartupCost;
import com.nyiso.marketplace.businessobjects.bidding.generator.commitment.UnitCommitment;
import com.nyiso.marketplace.businessobjects.generator.GeneratorUnitCommitmentDataStatus;
import java.math.BigDecimal;

public class UnitCommitmentParameters {
    private static final Integer GEN_MAX_STOPS_PER_DAY = 13;

    public boolean isValidUnitCommitmentParametersState(UnitCommitment uc) {
        if (null == uc) {
            return false;
        }
        GeneratorUnitCommitmentDataStatus ucStatus = this.validateUnitCommitmentData(uc);
        boolean runtimeDownTimeOk = ucStatus.isPassedMinimumRuntimeCheck() && ucStatus.isPassedMinimumDowntimeCheck();
        boolean miscChecksOk = ucStatus.isPassedMaxStopsPerDayCheck() && ucStatus.isPassedStartupNotificationCheck();
        return miscChecksOk && runtimeDownTimeOk && this.ucCurveCheckStatus(ucStatus);
    }

    private boolean ucCurveCheckStatus(GeneratorUnitCommitmentDataStatus ucStatus) {
        boolean costCurveOk = ucStatus.isPassedStartupCurveFirstPointCheck() && ucStatus.isPassedStartupCurveAllButFirstFirstPointCheck();
        boolean timeCurveOk = ucStatus.isPassedStartupNotificationTimeCurveFirstPointCheck() && ucStatus.isPassedStartupNotificationTimeCurveAllButFirstPointCheck();
        return costCurveOk && timeCurveOk;
    }

    public GeneratorUnitCommitmentDataStatus validateUnitCommitmentData(UnitCommitment ucData) {
        if (ucData == null) {
            return null;
        }
        boolean passedMaxStopsPerDayCheck = this.checkMaxStopsPerDay(ucData);
        boolean passedMinimumRuntimeCheck = this.checkMinimumRuntime(ucData);
        boolean passedMinimumDowntimeCheck = this.checkMinimumDowntime(ucData);
        boolean passedStartupNotificationCheck = this.checkStartupNotificationTime(ucData);
        boolean passedStartupCurveFirstPointCheck = this.checkStartupCurveFirstPoint(ucData);
        boolean isPassedStartupCurveAllButFirstFirstPointCheck = this.checkSinglePointStartupCostCurve(ucData);
        boolean passedNotificationTimeCurveFirstPointCheck = this.checkNotificationTimeCurveFirstPoint(ucData);
        boolean isPassedNotificationTimeCurveAllButFirstPointCheck = this.checkNotificationTimeCurveAllButFirstPoint(ucData);
        return new GeneratorUnitCommitmentDataStatus(passedMaxStopsPerDayCheck, passedMinimumRuntimeCheck, passedMinimumDowntimeCheck, passedStartupNotificationCheck, passedStartupCurveFirstPointCheck, isPassedStartupCurveAllButFirstFirstPointCheck, passedNotificationTimeCurveFirstPointCheck, isPassedNotificationTimeCurveAllButFirstPointCheck);
    }

    private boolean checkMaxStopsPerDay(UnitCommitment ucData) {
        return ucData.getMaxStopsPerDay() != null && ucData.getMaxStopsPerDay().intValue() == GEN_MAX_STOPS_PER_DAY.intValue();
    }

    private boolean checkMinimumRuntime(UnitCommitment ucData) {
        return ucData.getMinRunTime() != null && ucData.getMinRunTime().intValue() == 0;
    }

    private boolean checkMinimumDowntime(UnitCommitment ucData) {
        return ucData.getMinDownTime() != null && ucData.getMinDownTime().intValue() == 0;
    }

    private boolean checkStartupNotificationTime(UnitCommitment ucData) {
        return ucData.getStartUpNotificationTime() != null && ucData.getStartUpNotificationTime().compareTo(BigDecimal.ZERO) == 0;
    }

    private boolean checkStartupCurveFirstPoint(UnitCommitment ucData) {
        StartupCost firstPoint;
        boolean passedStartupCurveFirstPointCheck = false;
        if (ucData.getStartupCostCurve() != null && !ucData.getStartupCostCurve().isEmpty() && (firstPoint = ucData.getStartupCostCurve().get(0)) != null && this.isBigDecimalZero(firstPoint.getStartupCost()) && this.isBigDecimalZero(firstPoint.getHoursOffLine())) {
            passedStartupCurveFirstPointCheck = true;
        }
        return passedStartupCurveFirstPointCheck;
    }

    private boolean isBigDecimalZero(BigDecimal bdObj) {
        return null != bdObj && bdObj.compareTo(BigDecimal.ZERO) == 0;
    }

    private boolean checkSinglePointStartupCostCurve(UnitCommitment ucData) {
        boolean isPassedStartupCurveAllButFirstFirstPointCheck = true;
        if (ucData.getStartupCostCurve() != null && ucData.getStartupCostCurve().size() > 1) {
            for (int i = 1; i < ucData.getStartupCostCurve().size(); ++i) {
                StartupCost sc = ucData.getStartupCostCurve().get(i);
                if (sc == null || sc.getHoursOffLine() == null && sc.getStartupCost() == null) continue;
                isPassedStartupCurveAllButFirstFirstPointCheck = false;
                break;
            }
        }
        return isPassedStartupCurveAllButFirstFirstPointCheck;
    }

    private boolean checkNotificationTimeCurveFirstPoint(UnitCommitment ucData) {
        NotificationTime firstPoint;
        boolean passedNotificationTimeCurveFirstPointCheck = false;
        if (ucData.getNotificationTimeCurve() != null && !ucData.getNotificationTimeCurve().isEmpty() && (firstPoint = ucData.getNotificationTimeCurve().get(0)) != null && this.isBigDecimalZero(firstPoint.getHoursToStart()) && this.isBigDecimalZero(firstPoint.getHoursOffLine())) {
            passedNotificationTimeCurveFirstPointCheck = true;
        }
        return passedNotificationTimeCurveFirstPointCheck;
    }

    private boolean checkNotificationTimeCurveAllButFirstPoint(UnitCommitment ucData) {
        boolean passedNotificationTimeCurveAllButFirstPointCheck = true;
        if (ucData.getNotificationTimeCurve() != null && ucData.getNotificationTimeCurve().size() > 1) {
            for (int i = 1; i < ucData.getNotificationTimeCurve().size(); ++i) {
                NotificationTime sc = ucData.getNotificationTimeCurve().get(i);
                if (sc == null || sc.getHoursOffLine() == null && sc.getHoursToStart() == null) continue;
                passedNotificationTimeCurveAllButFirstPointCheck = false;
                break;
            }
        }
        return passedNotificationTimeCurveAllButFirstPointCheck;
    }
}

