/*
 * Decompiled with CFR 0.152.
 */
package domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import domain.SubmissionParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubmissionRequest<T> {
    private SubmissionParameters submissionParameters = new SubmissionParameters();
    @JsonIgnore
    private String username;
    @JsonIgnore
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<T> bids = new ArrayList<T>();

    @JsonAnyGetter
    public Map<String, Object> getBidsWithAlias() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.bids != null && !this.bids.isEmpty() && this.submissionParameters != null) {
            String requestType = this.submissionParameters.getRequestType();
            String propertyName = this.getBidsPropertyName(requestType);
            map.put(propertyName, this.bids);
        }
        return map;
    }

    private String getBidsPropertyName(String requestType) {
        if (requestType == null) {
            return "bids";
        }
        switch (requestType) {
            case "DELETE_LOAD_BID": {
                return "deleteLoadBids";
            }
            case "LOAD_BID": {
                return "submitLoadBids";
            }
            case "DELETE_GEN_BID": {
                return "deleteGeneratorBids";
            }
            case "GEN_BID": {
                return "submitGeneratorBids";
            }
            case "UC_DATA": {
                return "unitCommitmentData";
            }
            case "DELETE_TRAN_BID": {
                return "deleteTransactionBids";
            }
            case "TRAN_BID": {
                return "submitTransactionBids";
            }
            case "CONFIRM_TRAN_BID": {
                return "confirmTransactionBids";
            }
        }
        return "bids";
    }

    @Generated
    public SubmissionRequest() {
    }

    @Generated
    public SubmissionParameters getSubmissionParameters() {
        return this.submissionParameters;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public List<T> getBids() {
        return this.bids;
    }

    @Generated
    public void setSubmissionParameters(SubmissionParameters submissionParameters) {
        this.submissionParameters = submissionParameters;
    }

    @JsonIgnore
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    @Generated
    public void setBids(List<T> bids) {
        this.bids = bids;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubmissionRequest)) {
            return false;
        }
        SubmissionRequest other = (SubmissionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SubmissionParameters this$submissionParameters = this.getSubmissionParameters();
        SubmissionParameters other$submissionParameters = other.getSubmissionParameters();
        if (this$submissionParameters == null ? other$submissionParameters != null : !((Object)this$submissionParameters).equals(other$submissionParameters)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        List<T> this$bids = this.getBids();
        List<T> other$bids = other.getBids();
        return !(this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubmissionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SubmissionParameters $submissionParameters = this.getSubmissionParameters();
        result = result * 59 + ($submissionParameters == null ? 43 : ((Object)$submissionParameters).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        List<T> $bids = this.getBids();
        result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SubmissionRequest(submissionParameters=" + this.getSubmissionParameters() + ", username=" + this.getUsername() + ", bids=" + this.getBids() + ")";
    }
}

