/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import domain.SubmissionParameters;
import domain.SubmissionRequest;
import domain.generator.DeleteGeneratorBidDto;
import domain.generator.SubmitGeneratorBidDto;
import domain.generator.UnitCommitmentDto;
import domain.load.DeleteLoadBidDto;
import domain.load.SubmitLoadBidDto;
import domain.transaction.ConfirmTranBidDto;
import domain.transaction.DeleteTranBidDto;
import domain.transaction.TranBidDto;
import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ReadCSVFile {
    private static final ZoneId EASTERN_TIME_ZONE = ZoneId.of("America/New_York");

    ReadCSVFile() {
    }

    public static void main(String[] args) {
        String output = "";
        try {
            Scanner user = new Scanner(System.in);
            System.out.println("Hello! Please type your full file path here to get your file converted to the new system.");
            System.out.println("Please ensure the file you are entering is a csv.");
            System.out.print("File Path: ");
            String filePath = user.nextLine();
            user.close();
            String queryType = "";
            File file = new File(filePath);
            Scanner fileReader = new Scanner(file);
            HashSet<String> datesWithHour25 = new HashSet<String>();
            Scanner prescanReader = new Scanner(file);
            while (prescanReader.hasNextLine()) {
                String datePart;
                String line = prescanReader.nextLine();
                if (!line.contains(" 25:") || (datePart = ReadCSVFile.extractDateWithHour25(line)) == null) continue;
                datesWithHour25.add(datePart);
            }
            prescanReader.close();
            SubmissionRequest<DeleteLoadBidDto> request = null;
            block47: while (fileReader.hasNextLine()) {
                String tmp = fileReader.nextLine();
                String row = tmp.contains("&") ? tmp.replace("\ufeff", "").substring(0, tmp.indexOf("&")) : tmp.replace("\ufeff", "");
                if (row.contains("QUERY_TYPE")) {
                    queryType = output = ReadCSVFile.getQueryType(row);
                    continue;
                }
                if (row.contains("=")) {
                    switch (row.split("=")[0]) {
                        case "BID_TYPE": {
                            request = new SubmissionRequest<DeleteLoadBidDto>();
                            SubmissionParameters params = new SubmissionParameters();
                            params.setDoCommit(true);
                            params.setRequestType(ReadCSVFile.getBidType(row));
                            request.setSubmissionParameters(params);
                            request.setBids(new ArrayList());
                            break;
                        }
                        case "USERID": 
                        case "PASSWORD": {
                            break;
                        }
                        case "GENERATOR": {
                            output = output + ReadCSVFile.getIdentifier(row, output, "genName", "ptid");
                            break;
                        }
                        case "LOAD_AREA_BUS": {
                            output = output + ReadCSVFile.getIdentifier(row, output, "loadName", "ptid");
                            break;
                        }
                        case "SOURCE": {
                            output = output + ReadCSVFile.getIdentifier(row, output, "sourceName", "sourcePtid");
                            break;
                        }
                        case "SINK": {
                            output = output + ReadCSVFile.getIdentifier(row, output, "sinkName", "sinkPtid");
                            break;
                        }
                        case "PROCESS_UNIDENTIFIED_BIDS": {
                            if (request == null || request.getSubmissionParameters() == null) continue block47;
                            request.getSubmissionParameters().setProcessUnidentifiedBids(row.split("=")[1].split(",")[0].equalsIgnoreCase("y"));
                            break;
                        }
                        case "OUTAGES": {
                            output = output + ReadCSVFile.getOutput(row, output, "genOutages", queryType);
                            break;
                        }
                        default: {
                            output = output + ReadCSVFile.getOutput(row, output, null, queryType);
                            break;
                        }
                    }
                    continue;
                }
                if (request == null || request.getSubmissionParameters() == null) continue;
                switch (request.getSubmissionParameters().getRequestType()) {
                    case "DELETE_LOAD_BID": {
                        ReadCSVFile.addDeleteLoadBidToRequest(row, request);
                        continue block47;
                    }
                    case "LOAD_BID": {
                        ReadCSVFile.addLoadBidToRequest(row, request, datesWithHour25);
                        continue block47;
                    }
                    case "DELETE_GEN_BID": {
                        ReadCSVFile.addDeleteGenBidToRequest(row, request);
                        continue block47;
                    }
                    case "GEN_BID": {
                        ReadCSVFile.addGenBidToRequest(row, request, datesWithHour25);
                        continue block47;
                    }
                    case "UC_DATA": {
                        ReadCSVFile.addUnitCommitmentDataToRequest(row, request);
                        continue block47;
                    }
                    case "DELETE_TRAN_BID": {
                        ReadCSVFile.addDeleteTranBidToRequest(row, request);
                        continue block47;
                    }
                    case "TRAN_BID": {
                        ReadCSVFile.addSubmitTranBidToRequest(row, request, datesWithHour25);
                        continue block47;
                    }
                    case "CONFIRM_TRAN_BID": {
                        ReadCSVFile.addConfirmTranBidToRequest(row, request);
                        continue block47;
                    }
                }
                System.out.println("Invalid bid type entered.");
            }
            if (request == null) {
                System.out.println(output);
            } else {
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                System.out.println(ow.writeValueAsString(request));
            }
            fileReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("That file was not found.");
        }
        catch (JsonProcessingException e) {
            System.out.println("An exception occurred translating the object to json.");
        }
        catch (DateTimeParseException e) {
            System.out.println("An invalid date was entered. Please make sure your dates are in the following format: MM/dd/yyyy hh:mm or MM/dd/yyyy hh:mm:ss");
        }
        catch (Exception e) {
            System.out.println("The CSV file entered is invalid.");
        }
    }

    private static void addDeleteLoadBidToRequest(String row, SubmissionRequest<DeleteLoadBidDto> request) {
        DeleteLoadBidDto loadBid = new DeleteLoadBidDto();
        String[] data = row.replace(",,", ", ,").split(",");
        try {
            loadBid.setBidId(ReadCSVFile.getInteger(data[0]));
            String loadIdentifier = data[1];
            if (loadIdentifier != null && !loadIdentifier.trim().isEmpty()) {
                if (ReadCSVFile.isInteger(loadIdentifier)) {
                    int ptid = Integer.parseInt(loadIdentifier);
                    loadBid.setPtid(ptid);
                } else {
                    loadBid.setLoadName(loadIdentifier);
                }
            }
            loadBid.setBidDate(ReadCSVFile.getDate(data[2]));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (request != null && request.getBids() != null) {
            request.getBids().add(loadBid);
        }
    }

    private static void addDeleteTranBidToRequest(String row, SubmissionRequest<DeleteTranBidDto> request) {
        DeleteTranBidDto tranBid = new DeleteTranBidDto();
        String[] data = row.replace(",,", ", ,").split(",");
        try {
            tranBid.setBidId(ReadCSVFile.getInteger(data[0]));
            tranBid.setTranId(ReadCSVFile.getInteger(data[1]));
            tranBid.setBidDate(ReadCSVFile.getDate(data[2]));
            tranBid.setMarket(ReadCSVFile.getString(data[3]));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (request != null && request.getBids() != null) {
            request.getBids().add(tranBid);
        }
    }

    private static void addConfirmTranBidToRequest(String row, SubmissionRequest<ConfirmTranBidDto> request) {
        ConfirmTranBidDto tranBid = new ConfirmTranBidDto();
        String[] data = row.replace(",,", ", ,").split(",");
        try {
            tranBid.setBidId(ReadCSVFile.getInteger(data[0]));
            tranBid.setTranId(ReadCSVFile.getInteger(data[1]));
            tranBid.setBidDate(ReadCSVFile.getDate(data[2]));
            tranBid.setMarket(ReadCSVFile.getString(data[3]));
            if (data[4] != null && !data[4].isEmpty()) {
                tranBid.setConfirmStatus(data[4].trim().equalsIgnoreCase("y"));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (request != null && request.getBids() != null) {
            request.getBids().add(tranBid);
        }
    }

    private static void addSubmitTranBidToRequest(String row, SubmissionRequest<TranBidDto> request, Set<String> datesWithHour25) {
        String[] data = row.replace(",,", ", ,").split(",");
        List<ZonedDateTime> bidDates = ReadCSVFile.getDates(data.length > 0 ? data[0] : null, datesWithHour25);
        if (bidDates.isEmpty()) {
            bidDates.add(null);
        }
        for (ZonedDateTime bidDate : bidDates) {
            TranBidDto tranBid = new TranBidDto();
            try {
                String sinkIdentifier;
                tranBid.setBidDate(bidDate);
                String sourceIdentifier = data[1];
                if (sourceIdentifier != null && !sourceIdentifier.isEmpty()) {
                    if (ReadCSVFile.isInteger(sourceIdentifier)) {
                        int id = Integer.parseInt(sourceIdentifier);
                        tranBid.setSourcePtid(id);
                    } else {
                        tranBid.setSourceName(sourceIdentifier);
                    }
                }
                if ((sinkIdentifier = data[2]) != null && !sinkIdentifier.isEmpty()) {
                    if (ReadCSVFile.isInteger(sinkIdentifier)) {
                        int id = Integer.parseInt(sinkIdentifier);
                        tranBid.setSinkPtid(id);
                    } else {
                        tranBid.setSinkName(sinkIdentifier);
                    }
                }
                tranBid.setMarket(ReadCSVFile.getString(data[3]));
                tranBid.setNercPriority(ReadCSVFile.getInteger(data[9]));
                tranBid.setUserReference(ReadCSVFile.getString(data[10]));
                tranBid.setBidEnergyMw(ReadCSVFile.getBigDecimal(data[12]));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (request == null || request.getBids() == null) continue;
            request.getBids().add(tranBid);
        }
    }

    private static void addDeleteGenBidToRequest(String row, SubmissionRequest<DeleteGeneratorBidDto> request) {
        DeleteGeneratorBidDto genBid = new DeleteGeneratorBidDto();
        String[] data = row.replace(",,", ", ,").split(",");
        try {
            genBid.setBidId(ReadCSVFile.getInteger(data[0]));
            String genIdentifier = data[1];
            if (genIdentifier != null && !genIdentifier.trim().isEmpty()) {
                if (ReadCSVFile.isInteger(genIdentifier)) {
                    int ptid = Integer.parseInt(genIdentifier);
                    genBid.setPtid(ptid);
                } else {
                    genBid.setGeneratorName(genIdentifier);
                }
            }
            genBid.setBidDate(ReadCSVFile.getDate(data[2]));
            genBid.setMarket(ReadCSVFile.getString(data[3]));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (request != null && request.getBids() != null) {
            request.getBids().add(genBid);
        }
    }

    private static void addUnitCommitmentDataToRequest(String row, SubmissionRequest<UnitCommitmentDto> request) {
        UnitCommitmentDto unitCommitment = new UnitCommitmentDto();
        String[] data = row.replace(",,", ", ,").split(",");
        try {
            String genIdentifier = data[0];
            if (genIdentifier != null && !genIdentifier.trim().isEmpty()) {
                if (ReadCSVFile.isInteger(genIdentifier)) {
                    int ptid = Integer.parseInt(genIdentifier);
                    unitCommitment.setPtid(ptid);
                } else {
                    unitCommitment.setGeneratorName(genIdentifier);
                }
            }
            unitCommitment.setMinRunTime(ReadCSVFile.getBigDecimal(data[1]));
            unitCommitment.setMinDownTime(ReadCSVFile.getBigDecimal(data[2]));
            unitCommitment.setMaxStopsPerDay(ReadCSVFile.getInteger(data[3]));
            unitCommitment.setStartUpNotificationTime(ReadCSVFile.getBigDecimal(data[4]));
            unitCommitment.setStartUpBidTime1(ReadCSVFile.getBigDecimal(data[5]));
            unitCommitment.setStartUpBidTime2(ReadCSVFile.getBigDecimal(data[6]));
            unitCommitment.setStartUpBidTime3(ReadCSVFile.getBigDecimal(data[7]));
            unitCommitment.setStartUpBidTime4(ReadCSVFile.getBigDecimal(data[8]));
            unitCommitment.setStartUpBidTime5(ReadCSVFile.getBigDecimal(data[9]));
            unitCommitment.setStartUpBidTime6(ReadCSVFile.getBigDecimal(data[10]));
            unitCommitment.setStartUpBidCost1(ReadCSVFile.getBigDecimal(data[11]));
            unitCommitment.setStartUpBidCost2(ReadCSVFile.getBigDecimal(data[12]));
            unitCommitment.setStartUpBidCost3(ReadCSVFile.getBigDecimal(data[13]));
            unitCommitment.setStartUpBidCost4(ReadCSVFile.getBigDecimal(data[14]));
            unitCommitment.setStartUpBidCost5(ReadCSVFile.getBigDecimal(data[15]));
            unitCommitment.setStartUpBidCost6(ReadCSVFile.getBigDecimal(data[16]));
            unitCommitment.setNotificationHoursToStart1(ReadCSVFile.getBigDecimal(data[17]));
            unitCommitment.setNotificationHoursToStart2(ReadCSVFile.getBigDecimal(data[19]));
            unitCommitment.setNotificationHoursToStart3(ReadCSVFile.getBigDecimal(data[10]));
            unitCommitment.setNotificationHoursToStart4(ReadCSVFile.getBigDecimal(data[20]));
            unitCommitment.setNotificationHoursToStart5(ReadCSVFile.getBigDecimal(data[21]));
            unitCommitment.setNotificationHoursToStart6(ReadCSVFile.getBigDecimal(data[22]));
            unitCommitment.setNotificationHoursOffline1(ReadCSVFile.getBigDecimal(data[23]));
            unitCommitment.setNotificationHoursOffline2(ReadCSVFile.getBigDecimal(data[24]));
            unitCommitment.setNotificationHoursOffline3(ReadCSVFile.getBigDecimal(data[25]));
            unitCommitment.setNotificationHoursOffline4(ReadCSVFile.getBigDecimal(data[26]));
            unitCommitment.setNotificationHoursOffline5(ReadCSVFile.getBigDecimal(data[27]));
            unitCommitment.setNotificationHoursOffline6(ReadCSVFile.getBigDecimal(data[28]));
            unitCommitment.setCommitmentId(ReadCSVFile.getInteger(data[29]));
            unitCommitment.setUpdateUser(ReadCSVFile.getString(data[30]));
            unitCommitment.setUpdateTime(ReadCSVFile.getDate(data[31]));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (request != null && request.getBids() != null) {
            request.getBids().add(unitCommitment);
        }
    }

    private static void addLoadBidToRequest(String row, SubmissionRequest<SubmitLoadBidDto> request, Set<String> datesWithHour25) {
        String[] data = row.replace(",,", ", ,").split(",");
        List<ZonedDateTime> bidDates = ReadCSVFile.getDates(data.length > 1 ? data[1] : null, datesWithHour25);
        if (bidDates.isEmpty()) {
            bidDates.add(null);
        }
        for (ZonedDateTime bidDate : bidDates) {
            SubmitLoadBidDto loadBid = new SubmitLoadBidDto();
            try {
                String loadIdentifier = data[0];
                if (loadIdentifier != null && !loadIdentifier.trim().isEmpty()) {
                    if (ReadCSVFile.isInteger(loadIdentifier)) {
                        int ptid = Integer.parseInt(loadIdentifier);
                        loadBid.setPtid(ptid);
                    } else {
                        loadBid.setLoadName(loadIdentifier);
                    }
                }
                loadBid.setBidDate(bidDate);
                loadBid.setForecastMw(ReadCSVFile.getBigDecimal(data[2]));
                loadBid.setFixedBidMw(ReadCSVFile.getBigDecimal(data[3]));
                loadBid.setPriceCap1Mw(ReadCSVFile.getBigDecimal(data[4]));
                loadBid.setPriceCap1MwDollar(ReadCSVFile.getFloat(data[5]));
                loadBid.setPriceCap2Mw(ReadCSVFile.getBigDecimal(data[6]));
                loadBid.setPriceCap2MwDollar(ReadCSVFile.getFloat(data[7]));
                loadBid.setPriceCap3Mw(ReadCSVFile.getBigDecimal(data[8]));
                loadBid.setPriceCap3MwDollar(ReadCSVFile.getFloat(data[9]));
                loadBid.setInterruptType(ReadCSVFile.getString(data[10]));
                loadBid.setInterruptFixedMw(ReadCSVFile.getBigDecimal(data[11]));
                loadBid.setInterruptFixedMwDollar(ReadCSVFile.getFloat(data[12]));
                loadBid.setInterruptPriceCapMw(ReadCSVFile.getBigDecimal(data[13]));
                loadBid.setInterruptPriceCapMwDollar(ReadCSVFile.getFloat(data[14]));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (request == null || request.getBids() == null) continue;
            request.getBids().add(loadBid);
        }
    }

    private static void addGenBidToRequest(String row, SubmissionRequest<SubmitGeneratorBidDto> request, Set<String> datesWithHour25) {
        String[] data = row.replace(",,", ", ,").split(",");
        List<ZonedDateTime> bidDates = ReadCSVFile.getDates(data.length > 1 ? data[1] : null, datesWithHour25);
        if (bidDates.isEmpty()) {
            bidDates.add(null);
        }
        for (ZonedDateTime bidDate : bidDates) {
            SubmitGeneratorBidDto genBid = new SubmitGeneratorBidDto();
            try {
                String genIdentifier = data[0];
                if (genIdentifier != null && !genIdentifier.trim().isEmpty()) {
                    if (ReadCSVFile.isInteger(genIdentifier)) {
                        int ptid = Integer.parseInt(genIdentifier);
                        genBid.setPtid(ptid);
                    } else {
                        genBid.setGeneratorName(genIdentifier);
                    }
                }
                genBid.setBidDate(bidDate);
                genBid.setNumHours(ReadCSVFile.getInteger(data[2]));
                genBid.setMarket(ReadCSVFile.getString(data[3]));
                genBid.setExpirationDate(ReadCSVFile.getDate(data[4]));
                genBid.setUpperOperatingLimit(ReadCSVFile.getBigDecimal(data[5]));
                genBid.setEmergencyUpperOperatingLimit(ReadCSVFile.getBigDecimal(data[6]));
                genBid.setFuelTypeId(ReadCSVFile.getInteger(data[7]));
                genBid.setFuelPrice(ReadCSVFile.getBigDecimal(data[8]));
                genBid.setStartupCost(ReadCSVFile.getBigDecimal(data[9]));
                genBid.setScheduleTypeId(ReadCSVFile.getInteger(data[10]));
                genBid.setSelfCommMw00(ReadCSVFile.getBigDecimal(data[11]));
                genBid.setSelfCommMw15(ReadCSVFile.getBigDecimal(data[12]));
                genBid.setSelfCommMw30(ReadCSVFile.getBigDecimal(data[13]));
                genBid.setSelfCommMw45(ReadCSVFile.getBigDecimal(data[14]));
                genBid.setFixedMinimumGenerationMw(ReadCSVFile.getBigDecimal(data[15]));
                genBid.setFixedMinimumGenerationCost(ReadCSVFile.getBigDecimal(data[16]));
                genBid.setDispatchMw1(ReadCSVFile.getBigDecimal(data[17]));
                genBid.setDispatchMw2(ReadCSVFile.getBigDecimal(data[18]));
                genBid.setDispatchMw3(ReadCSVFile.getBigDecimal(data[19]));
                genBid.setDispatchMw4(ReadCSVFile.getBigDecimal(data[20]));
                genBid.setDispatchMw5(ReadCSVFile.getBigDecimal(data[21]));
                genBid.setDispatchMw6(ReadCSVFile.getBigDecimal(data[22]));
                genBid.setDispatchMw7(ReadCSVFile.getBigDecimal(data[23]));
                genBid.setDispatchMw8(ReadCSVFile.getBigDecimal(data[24]));
                genBid.setDispatchMw9(ReadCSVFile.getBigDecimal(data[25]));
                genBid.setDispatchMw10(ReadCSVFile.getBigDecimal(data[26]));
                genBid.setDispatchMw11(ReadCSVFile.getBigDecimal(data[27]));
                genBid.setDispatchDollar1(ReadCSVFile.getBigDecimal(data[28]));
                genBid.setDispatchDollar2(ReadCSVFile.getBigDecimal(data[29]));
                genBid.setDispatchDollar3(ReadCSVFile.getBigDecimal(data[30]));
                genBid.setDispatchDollar4(ReadCSVFile.getBigDecimal(data[31]));
                genBid.setDispatchDollar5(ReadCSVFile.getBigDecimal(data[32]));
                genBid.setDispatchDollar6(ReadCSVFile.getBigDecimal(data[33]));
                genBid.setDispatchDollar7(ReadCSVFile.getBigDecimal(data[34]));
                genBid.setDispatchDollar8(ReadCSVFile.getBigDecimal(data[35]));
                genBid.setDispatchDollar9(ReadCSVFile.getBigDecimal(data[36]));
                genBid.setDispatchDollar10(ReadCSVFile.getBigDecimal(data[37]));
                genBid.setDispatchDollar11(ReadCSVFile.getBigDecimal(data[38]));
                genBid.setTenMinNonSynchCost(ReadCSVFile.getBigDecimal(data[39]));
                genBid.setTenMinSpinCost(ReadCSVFile.getBigDecimal(data[40]));
                genBid.setThirtyMinNonSynchCost(ReadCSVFile.getBigDecimal(data[41]));
                genBid.setThirtyMinSpinCost(ReadCSVFile.getBigDecimal(data[42]));
                genBid.setRegulationMw(ReadCSVFile.getBigDecimal(data[43]));
                genBid.setRegulationCost(ReadCSVFile.getBigDecimal(data[44]));
                genBid.setRegulationMovementCost(ReadCSVFile.getBigDecimal(data[45]));
                genBid.setOpportunityCost1(ReadCSVFile.getBigDecimal(data[46]));
                genBid.setOpportunityCost2(ReadCSVFile.getBigDecimal(data[47]));
                genBid.setOpportunityCost3(ReadCSVFile.getBigDecimal(data[48]));
                genBid.setOpportunityCost4(ReadCSVFile.getBigDecimal(data[49]));
                genBid.setOpportunityCost5(ReadCSVFile.getBigDecimal(data[50]));
                genBid.setOpportunityCost6(ReadCSVFile.getBigDecimal(data[51]));
                genBid.setOpportunityCost7(ReadCSVFile.getBigDecimal(data[52]));
                genBid.setOpportunityCost8(ReadCSVFile.getBigDecimal(data[53]));
                genBid.setOpportunityCost9(ReadCSVFile.getBigDecimal(data[54]));
                genBid.setOpportunityCost10(ReadCSVFile.getBigDecimal(data[55]));
                genBid.setOpportunityCost11(ReadCSVFile.getBigDecimal(data[56]));
                genBid.setEsrBeginningEnergyLevel(ReadCSVFile.getBigDecimal(data[57]));
                genBid.setEsrLowerStorageLimit(ReadCSVFile.getBigDecimal(data[58]));
                genBid.setEsrUpperStorageLimit(ReadCSVFile.getBigDecimal(data[59]));
                genBid.setEsrManagementMode(data[60]);
                genBid.setEsrLowerOperatingLimit(ReadCSVFile.getBigDecimal(data[61]));
                genBid.setHostLoadMw(ReadCSVFile.getBigDecimal(data[63]));
                genBid.setCsrOutageType(data[64]);
                genBid.setCsrInjectionLimit(ReadCSVFile.getBigDecimal(data[65]));
                genBid.setCsrWithdrawalLimit(ReadCSVFile.getBigDecimal(data[66]));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (request == null || request.getBids() == null) continue;
            request.getBids().add(genBid);
        }
    }

    private static String getString(String value) {
        if (value != null && !value.trim().isEmpty()) {
            return value;
        }
        return null;
    }

    private static Integer getInteger(String value) {
        if (value != null && !value.trim().isEmpty() && !" ".equals(value)) {
            if (ReadCSVFile.isInteger(value)) {
                return Integer.valueOf(value);
            }
            System.out.println("Error: " + value + " is an invalid entry.");
        }
        return null;
    }

    private static List<ZonedDateTime> getDates(String value, Set<String> datesWithHour25) {
        ArrayList<ZonedDateTime> result = new ArrayList<ZonedDateTime>();
        if (value != null && !value.trim().isEmpty()) {
            try {
                LocalDateTime localDate;
                String adjustedValue = value;
                boolean isSecondDstHour = false;
                if (value.contains(" 25:")) {
                    adjustedValue = value.replace(" 25:", " 01:");
                    isSecondDstHour = true;
                }
                try {
                    localDate = LocalDateTime.parse(adjustedValue, DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm"));
                }
                catch (DateTimeParseException e) {
                    localDate = LocalDateTime.parse(adjustedValue, DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"));
                }
                String datePortion = localDate.format(DateTimeFormatter.ofPattern("MM/dd/yyyy"));
                boolean dateHas25Hour = datesWithHour25 != null && datesWithHour25.contains(datePortion);
                ZonedDateTime zonedDate = ZonedDateTime.of(localDate, EASTERN_TIME_ZONE);
                if (isSecondDstHour) {
                    result.add(zonedDate.withLaterOffsetAtOverlap());
                } else if (ReadCSVFile.isDstOverlap(localDate) && !dateHas25Hour) {
                    result.add(zonedDate.withEarlierOffsetAtOverlap());
                    result.add(zonedDate.withLaterOffsetAtOverlap());
                } else {
                    result.add(zonedDate.withEarlierOffsetAtOverlap());
                }
            }
            catch (DateTimeParseException e) {
                System.out.println("Error parsing date: " + value);
            }
        }
        return result;
    }

    private static boolean isDstOverlap(LocalDateTime localDate) {
        ZonedDateTime earlier = ZonedDateTime.of(localDate, EASTERN_TIME_ZONE).withEarlierOffsetAtOverlap();
        ZonedDateTime later = ZonedDateTime.of(localDate, EASTERN_TIME_ZONE).withLaterOffsetAtOverlap();
        return !earlier.getOffset().equals(later.getOffset());
    }

    private static String extractDateWithHour25(String line) {
        Pattern pattern = Pattern.compile("(\\d{2}/\\d{2}/\\d{4})\\s+25:");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static ZonedDateTime getDate(String value) {
        if (value != null && !value.trim().isEmpty()) {
            try {
                LocalDateTime localDate;
                String adjustedValue = value;
                boolean isSecondDstHour = false;
                if (value.contains(" 25:")) {
                    adjustedValue = value.replace(" 25:", " 01:");
                    isSecondDstHour = true;
                }
                try {
                    localDate = LocalDateTime.parse(adjustedValue, DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm"));
                }
                catch (DateTimeParseException e) {
                    localDate = LocalDateTime.parse(adjustedValue, DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"));
                }
                ZonedDateTime zonedDate = ZonedDateTime.of(localDate, EASTERN_TIME_ZONE);
                if (isSecondDstHour) {
                    zonedDate = zonedDate.withLaterOffsetAtOverlap();
                }
                return zonedDate;
            }
            catch (DateTimeParseException e) {
                System.out.println("Error parsing date: " + value);
                return null;
            }
        }
        return null;
    }

    private static BigDecimal getBigDecimal(String value) {
        if (value != null && !value.trim().isEmpty() && !" ".equals(value)) {
            if (ReadCSVFile.isDouble(value)) {
                return BigDecimal.valueOf(Double.parseDouble(value));
            }
            System.out.println("Error: " + value + " is an invalid entry.");
        }
        return null;
    }

    private static Float getFloat(String value) {
        if (value != null && !value.trim().isEmpty() && !" ".equals(value)) {
            if (ReadCSVFile.isFloat(value)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            System.out.println("Error: " + value + " is an invalid entry.");
        }
        return null;
    }

    private static String getQueryType(String formData) {
        String queryType = formData.split("=")[1];
        return queryType.toLowerCase().replace("_", "-").trim().replace(",", "") + "?";
    }

    private static String getBidType(String formData) {
        String bidType = formData.split("=")[1];
        return bidType.trim().replace(",", "");
    }

    private static String getIdentifier(String formData, String output, String nameParam, String ptidParam) {
        String urlLoadArea = formData.split("=")[1];
        String value = urlLoadArea.trim().replace(",", "");
        if (ReadCSVFile.isInteger(value)) {
            if (ReadCSVFile.isFirstElement(output)) {
                return ptidParam + "=" + value;
            }
            return "&" + ptidParam + "=" + value;
        }
        if (ReadCSVFile.isFirstElement(output)) {
            return nameParam + "=" + value;
        }
        return "&" + nameParam + "=" + value;
    }

    private static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isFloat(String s) {
        try {
            Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isFirstElement(String s) {
        return !s.contains("=");
    }

    private static String getOutput(String formData, String output, String actualParam, String queryType) {
        String cleanData = formData.trim().replace(",", "");
        String[] parts = cleanData.split("=");
        if (parts.length != 2) {
            return "";
        }
        String param = parts[0];
        String value = parts[1];
        if (ReadCSVFile.isFirstElement(output)) {
            return ReadCSVFile.getFullString(param, value, actualParam, queryType);
        }
        return "&" + ReadCSVFile.getFullString(param, value, actualParam, queryType);
    }

    private static String getFullString(String param, String value, String actualParam, String queryType) {
        if (param.equalsIgnoreCase("DATE") || param.equalsIgnoreCase("BID_DATE")) {
            param = "START_DATE_TIME";
        }
        if (param.equals("MODIFIED_DATE") && queryType.contains("gen")) {
            param = "LAST_MODIFIED_DATE_TIME";
        }
        if (actualParam != null) {
            return actualParam + "=" + ReadCSVFile.getValue(param, value);
        }
        return ReadCSVFile.getNewParam(param) + "=" + ReadCSVFile.getValue(param, value);
    }

    private static String getValue(String param, String value) {
        if (param.contains("DATE")) {
            if (value != null && !value.trim().isEmpty()) {
                ZonedDateTime date = ReadCSVFile.getDate(value);
                return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX"));
            }
            return "";
        }
        return value;
    }

    private static String getNewParam(String param) {
        if ((param = param.replace(" ", "_")).contains("_")) {
            String[] word = param.split("_");
            StringBuilder sb = new StringBuilder(word[0].substring(0, 1).toLowerCase()).append(word[0].substring(1).toLowerCase());
            for (int i = 1; i < word.length; ++i) {
                sb.append(word[i].substring(0, 1).toUpperCase()).append(word[i].substring(1).toLowerCase());
            }
            return sb.toString();
        }
        return param.toLowerCase();
    }
}

