/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.common.data;

public class DataGrid {
    protected int currentRecord = -1;
    protected String[] attributeNames = null;
    protected Object[][] dataSet = null;

    public void setDataSource(Object[][] source) {
        this.dataSet = source;
    }

    public Object[][] getDataSource() {
        return this.dataSet;
    }

    public int size() {
        return this.dataSet.length;
    }

    public int getAttributeCount() {
        int colCount = 0;
        if (this.dataSet.length != 0) {
            colCount = this.dataSet[0].length;
        }
        return colCount;
    }

    public String getName(int attributeIndex) {
        return this.attributeNames[attributeIndex];
    }

    public String getString(int attributeIndex) {
        Object temp = this.dataSet[this.currentRecord][attributeIndex];
        if (temp == null) {
            temp = "";
        }
        return temp.toString();
    }

    public int getIntValue(int attributeIndex) throws NumberFormatException {
        return Integer.valueOf(this.getString(attributeIndex));
    }

    public float getFloatValue(int attributeIndex) throws NumberFormatException {
        return Float.valueOf(this.getString(attributeIndex)).floatValue();
    }

    public double getDoubleValue(int attributeIndex) throws NumberFormatException {
        return Double.valueOf(this.getString(attributeIndex));
    }

    public char getCharValue(int attributeIndex) {
        return this.getString(attributeIndex).charAt(0);
    }

    public Object getObject(int attributeIndex) {
        return this.dataSet[this.currentRecord][attributeIndex];
    }

    public boolean isNull(int attributeIndex) {
        boolean returnValue = false;
        if (this.getObject(attributeIndex) == null) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean next() {
        boolean returnValue = true;
        if (++this.currentRecord >= this.size()) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean previous() {
        boolean returnValue = true;
        if (--this.currentRecord <= -1) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean first() {
        this.currentRecord = 0;
        return true;
    }

    public boolean last() {
        this.currentRecord = this.size() - 1;
        return true;
    }

    public void reset() {
        this.currentRecord = -1;
    }

    public int getRowIndex() {
        return this.currentRecord;
    }
}

