/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.common.data.pool;

import com.nyiso.common.data.pool.DatabaseConnectionFactory;
import com.nyiso.common.data.pool.LdapConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class DataAccessFactory {
    private static DataAccessFactory instance = null;
    private static HashMap pools;
    public static final String DATABASE_PREFIX_STRING = "data";
    public static final String LDAP_PREFIX_STRING = "ldap";
    public static final String POOL_PREFIX_STRING = "pool";
    public static final String PARAMETER_DELIMETER = "-";
    private static Log log;
    static /* synthetic */ Class class$com$nyiso$common$data$pool$DataAccessFactory;

    public DataAccessFactory() {
        pools = new HashMap();
    }

    private void initialize(Map params) throws IOException {
        TreeSet keys = new TreeSet(params.keySet());
        Iterator paramKeys = keys.iterator();
        TreeMap<String, HashMap> dataPools = new TreeMap<String, HashMap>();
        TreeMap<String, HashMap> ldapPools = new TreeMap<String, HashMap>();
        TreeMap<String, HashMap> poolParams = new TreeMap<String, HashMap>();
        while (paramKeys.hasNext()) {
            String key = paramKeys.next().toString();
            log.debug((Object)key);
            StringTokenizer stringTok = new StringTokenizer(key.toString(), PARAMETER_DELIMETER);
            String identifier = stringTok.nextToken();
            String currentPoolName = "";
            String currentAtt = "";
            HashMap temp = null;
            if (identifier.equals(DATABASE_PREFIX_STRING)) {
                currentPoolName = stringTok.nextToken();
                currentAtt = stringTok.nextToken();
                if (!dataPools.containsKey("data-" + currentPoolName)) {
                    log.debug((Object)("adding new record for " + currentPoolName));
                    temp = new HashMap();
                    temp.put(currentAtt, params.get(key));
                    dataPools.put("data-" + currentPoolName, temp);
                    continue;
                }
                temp = (HashMap)dataPools.get("data-" + currentPoolName);
                temp.put(currentAtt, params.get(key));
                dataPools.put("data-" + currentPoolName, temp);
                continue;
            }
            if (identifier.equals(LDAP_PREFIX_STRING)) {
                currentPoolName = stringTok.nextToken();
                currentAtt = stringTok.nextToken();
                if (!ldapPools.containsKey("ldap-" + currentPoolName)) {
                    temp = new HashMap();
                    temp.put(currentAtt, params.get(key));
                    ldapPools.put("ldap-" + currentPoolName, temp);
                    continue;
                }
                temp = (HashMap)ldapPools.get("ldap-" + currentPoolName);
                temp.put(currentAtt, params.get(key));
                ldapPools.put("ldap-" + currentPoolName, temp);
                continue;
            }
            if (!identifier.equals(POOL_PREFIX_STRING)) continue;
            currentPoolName = stringTok.nextToken() + PARAMETER_DELIMETER + stringTok.nextToken();
            currentAtt = stringTok.nextToken();
            if (!poolParams.containsKey(currentPoolName)) {
                temp = new HashMap();
                temp.put(currentAtt, params.get(key));
                poolParams.put(currentPoolName, temp);
                continue;
            }
            temp = (HashMap)poolParams.get(currentPoolName);
            temp.put(currentAtt, params.get(key));
            log.debug((Object)("adding key " + currentAtt + " value: " + params.get(key).toString()));
            poolParams.put(currentPoolName, temp);
        }
        paramKeys = null;
        Iterator poolNames = poolParams.keySet().iterator();
        while (poolNames.hasNext()) {
            String currentPool = poolNames.next().toString();
            log.debug((Object)("POOL: " + currentPool));
            HashMap poolParameters = (HashMap)poolParams.get(currentPool);
            GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
            log.debug((Object)"Configuring...");
            poolConfig.maxActive = Integer.parseInt(poolParameters.get("maxActive").toString());
            poolConfig.maxIdle = Integer.parseInt(poolParameters.get("maxIdle").toString());
            poolConfig.maxWait = Integer.parseInt(poolParameters.get("maxWait").toString());
            poolConfig.minEvictableIdleTimeMillis = Integer.parseInt(poolParameters.get("minEvictableIdleTimeMillis").toString());
            poolConfig.numTestsPerEvictionRun = Integer.parseInt(poolParameters.get("numTestsPerEvictionRun").toString());
            poolConfig.testOnBorrow = Boolean.valueOf(poolParameters.get("testOnBorrow").toString());
            poolConfig.testOnReturn = Boolean.valueOf(poolParameters.get("testOnReturn").toString());
            poolConfig.testWhileIdle = Boolean.valueOf(poolParameters.get("testWhileIdle").toString());
            poolConfig.timeBetweenEvictionRunsMillis = Integer.parseInt(poolParameters.get("timeBetweenEvictionRunsMillis").toString());
            poolConfig.whenExhaustedAction = poolParameters.get("whenExhaustedAction").toString().equals("grow") ? (byte)2 : (poolParameters.get("whenExhaustedAction").toString().equals("fail") ? (byte)0 : 1);
            if (dataPools.containsKey(currentPool)) {
                pools.put(currentPool, new GenericObjectPool((PoolableObjectFactory)new DatabaseConnectionFactory((Map)dataPools.get(currentPool)), poolConfig));
            } else {
                log.debug((Object)"CREATED POOL");
                pools.put(currentPool, new GenericObjectPool((PoolableObjectFactory)new LdapConnectionFactory((Map)ldapPools.get(currentPool)), poolConfig));
            }
            poolConfig = null;
        }
        dataPools = null;
        ldapPools = null;
        poolParams = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessFactory getInstance() throws IOException {
        if (instance == null) {
            Class clazz = class$com$nyiso$common$data$pool$DataAccessFactory == null ? (class$com$nyiso$common$data$pool$DataAccessFactory = DataAccessFactory.class$("com.nyiso.common.data.pool.DataAccessFactory")) : class$com$nyiso$common$data$pool$DataAccessFactory;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new DataAccessFactory();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataAccessFactory getInstance(Map params) throws IOException {
        if (instance == null) {
            Class clazz = class$com$nyiso$common$data$pool$DataAccessFactory == null ? (class$com$nyiso$common$data$pool$DataAccessFactory = DataAccessFactory.class$("com.nyiso.common.data.pool.DataAccessFactory")) : class$com$nyiso$common$data$pool$DataAccessFactory;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new DataAccessFactory();
                    instance.initialize(params);
                }
            }
        }
        return instance;
    }

    public GenericObjectPool getDatabasePool() {
        return (GenericObjectPool)pools.get("data-default");
    }

    public GenericObjectPool getLdapPool() {
        return (GenericObjectPool)pools.get("ldap-default");
    }

    public GenericObjectPool getDatabasePool(String poolName) {
        return (GenericObjectPool)pools.get("data-" + poolName);
    }

    public GenericObjectPool getLdapPool(String poolName) {
        return (GenericObjectPool)pools.get("ldap-" + poolName);
    }

    public void close() throws Exception {
        Iterator toClose = pools.values().iterator();
        while (toClose.hasNext()) {
            GenericObjectPool current = (GenericObjectPool)toClose.next();
            current.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$com$nyiso$common$data$pool$DataAccessFactory == null ? (class$com$nyiso$common$data$pool$DataAccessFactory = DataAccessFactory.class$("com.nyiso.common.data.pool.DataAccessFactory")) : class$com$nyiso$common$data$pool$DataAccessFactory));
    }
}

