/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.common.data.pool;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.pool.PoolableObjectFactory;

public class LdapConnectionFactory
implements PoolableObjectFactory {
    private Hashtable environment;
    private Map params;

    public LdapConnectionFactory() {
    }

    public LdapConnectionFactory(Map parameters) {
        this.params = parameters;
    }

    public Object makeObject() throws Exception {
        if (this.environment == null) {
            this.environment = new Hashtable();
            this.environment.put("java.naming.provider.url", this.params.get("resourceUri"));
            this.environment.put("java.naming.security.principal", this.params.get("account"));
            this.environment.put("java.naming.security.credentials", this.params.get("key"));
            this.environment.put("java.naming.factory.initial", this.params.get("providerClass"));
            this.environment.put("java.naming.security.authentication", this.params.get("security"));
        }
        return new InitialDirContext(this.environment);
    }

    public void destroyObject(Object obj) throws Exception {
        DirContext context = (DirContext)obj;
        context.close();
        context = null;
    }

    public boolean validateObject(Object obj) {
        return obj != null;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void passivateObject(Object obj) throws Exception {
    }
}

