/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.bidding.bilateral;

import com.nyiso.marketplace.businessobjects.bidding.BidStatus;
import com.nyiso.marketplace.businessobjects.bidding.Market;
import com.nyiso.marketplace.businessobjects.bidding.bilateral.BilateralContract;
import com.nyiso.marketplace.common.map.keys.BilateralBidMapKey;
import com.nyiso.marketplace.common.validation.BilateralBidValidationMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BilateralBid
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 980360555565040255L;
    private Integer bidId = null;
    private Calendar bidDate = null;
    private BilateralContract contract = null;
    private BidStatus bidStatus = null;
    private Boolean frpConfStatus = null;
    private Boolean buyerConfStatus = null;
    private Boolean sellerConfStatus = null;
    private Market market = null;
    private List<BilateralBidValidationMessage> bidValidationMessages = null;

    public BilateralBid() {
    }

    public BilateralBid(BilateralBid bid) {
        this.bidId = bid.bidId;
        this.bidDate = bid.bidDate;
        this.contract = bid.contract;
        this.bidStatus = bid.bidStatus;
        this.frpConfStatus = bid.frpConfStatus;
        this.buyerConfStatus = bid.buyerConfStatus;
        this.sellerConfStatus = bid.sellerConfStatus;
        this.market = bid.market;
        this.bidValidationMessages = bid.bidValidationMessages;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("BilateralBid clone failed.", cnse);
        }
    }

    public Calendar getBidDate() {
        return this.bidDate;
    }

    public void setBidDate(Calendar bidDate) {
        this.bidDate = bidDate;
    }

    public Boolean getBuyerConfStatus() {
        return this.buyerConfStatus;
    }

    public void setBuyerConfStatus(Boolean buyerConfStatus) {
        this.buyerConfStatus = buyerConfStatus;
    }

    public Boolean getFrpConfStatus() {
        return this.frpConfStatus;
    }

    public void setFrpConfStatus(Boolean frpConfStatus) {
        this.frpConfStatus = frpConfStatus;
    }

    public Boolean getSellerConfStatus() {
        return this.sellerConfStatus;
    }

    public void setSellerConfStatus(Boolean sellerConfStatus) {
        this.sellerConfStatus = sellerConfStatus;
    }

    public Integer getBidId() {
        return this.bidId;
    }

    public void setBidId(Integer bidId) {
        this.bidId = bidId;
    }

    public BidStatus getBidStatus() {
        return this.bidStatus;
    }

    public void setBidStatus(BidStatus bidStatus) {
        this.bidStatus = bidStatus;
    }

    public Market getMarket() {
        return this.market;
    }

    public void setMarket(Market market) {
        this.market = market;
    }

    public BilateralContract getContract() {
        return this.contract;
    }

    public void setContract(BilateralContract contract) {
        this.contract = contract;
    }

    public List<BilateralBidValidationMessage> getBidValidationMessages() {
        return this.bidValidationMessages;
    }

    public void setBidValidationMessages(List<BilateralBidValidationMessage> bidValidationMessages) {
        this.bidValidationMessages = bidValidationMessages;
    }

    public void addValidationMessage(BilateralBidValidationMessage message) {
        if (this.bidValidationMessages == null) {
            this.bidValidationMessages = new ArrayList<BilateralBidValidationMessage>();
        }
        if (!this.bidValidationMessages.contains(message)) {
            this.bidValidationMessages.add(message);
        }
    }

    public BilateralBidMapKey getBidMapKey() {
        return new BilateralBidMapKey(this.contract.getContractId(), this.bidDate, this.market);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bidDate == null ? 0 : this.bidDate.hashCode());
        result = 31 * result + (this.bidStatus == null ? 0 : this.bidStatus.hashCode());
        result = 31 * result + (this.bidValidationMessages == null ? 0 : this.bidValidationMessages.hashCode());
        result = 31 * result + (this.buyerConfStatus == null ? 0 : this.buyerConfStatus.hashCode());
        result = 31 * result + (this.frpConfStatus == null ? 0 : this.frpConfStatus.hashCode());
        result = 31 * result + (this.sellerConfStatus == null ? 0 : this.sellerConfStatus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BilateralBid other = (BilateralBid)obj;
        if (this.bidDate == null ? other.bidDate != null : !this.bidDate.equals(other.bidDate)) {
            return false;
        }
        if (this.bidStatus == null ? other.bidStatus != null : !this.bidStatus.equals((Object)other.bidStatus)) {
            return false;
        }
        if (this.bidValidationMessages == null ? other.bidValidationMessages != null : !this.bidValidationMessages.equals(other.bidValidationMessages)) {
            return false;
        }
        if (this.buyerConfStatus == null ? other.buyerConfStatus != null : !this.buyerConfStatus.equals(other.buyerConfStatus)) {
            return false;
        }
        if (this.frpConfStatus == null ? other.frpConfStatus != null : !this.frpConfStatus.equals(other.frpConfStatus)) {
            return false;
        }
        return !(this.sellerConfStatus == null ? other.sellerConfStatus != null : !this.sellerConfStatus.equals(other.sellerConfStatus));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BilateralBid [");
        if (this.bidDate != null) {
            builder.append("bidDate=").append(this.bidDate).append(", ");
        }
        if (this.bidId != null) {
            builder.append("bidId=").append(this.bidId).append(", ");
        }
        if (this.bidStatus != null) {
            builder.append("bidStatus=").append((Object)this.bidStatus).append(", ");
        }
        if (this.bidValidationMessages != null) {
            builder.append("bidValidationMessages=").append(this.bidValidationMessages).append(", ");
        }
        if (this.buyerConfStatus != null) {
            builder.append("buyerConfStatus=").append(this.buyerConfStatus).append(", ");
        }
        if (this.contract != null) {
            builder.append("contract=").append(this.contract).append(", ");
        }
        if (this.frpConfStatus != null) {
            builder.append("frpConfStatus=").append(this.frpConfStatus).append(", ");
        }
        if (this.market != null) {
            builder.append("market=").append((Object)this.market).append(", ");
        }
        if (this.sellerConfStatus != null) {
            builder.append("sellerConfStatus=").append(this.sellerConfStatus).append(", ");
        }
        builder.append("]");
        return builder.toString();
    }
}

