/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.bidding.bilateral;

import com.nyiso.marketplace.businessobjects.bidding.BidStatus;
import com.nyiso.marketplace.businessobjects.bidding.bilateral.BilateralBid;
import com.nyiso.marketplace.businessobjects.bidding.bilateral.BilateralBidsReview;
import com.nyiso.marketplace.businessobjects.bidding.bilateral.InternalBilateralBid;
import com.nyiso.marketplace.businessobjects.bidding.bilateral.TradingHubBalancedStatus;
import com.nyiso.marketplace.businessobjects.common.Zone;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;

public class TradingHubDisplaySummary
extends BilateralBidsReview {
    private static final long serialVersionUID = 4196643696228151026L;
    private Zone zone = null;
    private BigDecimal mwTotal = null;
    private TradingHubBalancedStatus balancedStatus = null;
    private Calendar bidDate = null;

    public TradingHubDisplaySummary(Zone zone) {
        this.zone = zone;
        this.setBids(new ArrayList<BilateralBid>());
        this.mwTotal = BigDecimal.ZERO;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public BigDecimal getMwTotal() {
        return this.mwTotal;
    }

    public void setMwTotal(BigDecimal mwTotal) {
        this.mwTotal = mwTotal;
    }

    public TradingHubBalancedStatus getBalancedStatus() {
        return this.balancedStatus;
    }

    public void setBalancedStatus(TradingHubBalancedStatus balancedStatus) {
        this.balancedStatus = balancedStatus;
    }

    public Calendar getBidDate() {
        return this.bidDate;
    }

    public void setBidDate(Calendar bidDate) {
        this.bidDate = bidDate;
    }

    public void addBid(InternalBilateralBid bid) {
        this.getBids().add(bid);
        this.mwTotal = this.mwTotal.add(bid.getInternalBilateralMw());
        this.bidDate = bid.getBidDate();
        this.balancedStatus = bid.getBidStatus().equals((Object)BidStatus.BID_ACCEPTED) || bid.getBidStatus().equals((Object)BidStatus.VALIDATION_PASSED) || bid.getBidStatus().equals((Object)BidStatus.EVALUATING) ? (this.mwTotal.compareTo(BigDecimal.ZERO) == 0 ? TradingHubBalancedStatus.BALANCED : TradingHubBalancedStatus.UNBALANCED) : TradingHubBalancedStatus.NOT_APPLICABLE;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TradingHubDisplaySummary [");
        if (this.balancedStatus != null) {
            builder.append("balancedStatus=");
            builder.append((Object)this.balancedStatus);
            builder.append(", ");
        }
        if (this.bidDate != null) {
            builder.append("bidDate=");
            builder.append(this.bidDate);
            builder.append(", ");
        }
        if (this.mwTotal != null) {
            builder.append("mwTotal=");
            builder.append(this.mwTotal);
            builder.append(", ");
        }
        if (this.zone != null) {
            builder.append("zone=");
            builder.append(this.zone);
        }
        builder.append("[");
        builder.append(super.toString());
        builder.append("]]");
        return builder.toString();
    }
}

