/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.bidding.generator;

import com.nyiso.marketplace.businessobjects.bidding.BidStatus;
import com.nyiso.marketplace.businessobjects.bidding.EnergyCurvePoint;
import com.nyiso.marketplace.businessobjects.bidding.EsrManagementMode;
import com.nyiso.marketplace.businessobjects.bidding.UnitOutageType;
import com.nyiso.marketplace.businessobjects.bidding.generator.GenBidScheduleType;
import com.nyiso.marketplace.businessobjects.bidding.generator.GeneratorBidMarket;
import com.nyiso.marketplace.businessobjects.bidding.generator.GeneratorSchedule;
import com.nyiso.marketplace.businessobjects.bidding.generator.SelfCommitment;
import com.nyiso.marketplace.businessobjects.generator.FuelType;
import com.nyiso.marketplace.businessobjects.generator.Generator;
import com.nyiso.marketplace.common.validation.GeneratorBidValidationMessage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class GeneratorBid
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2370678796629220002L;
    private Integer bidId;
    private Calendar bidDate;
    private Integer bidDuration;
    private GeneratorBidMarket generatorBidMarket;
    private Generator generator;
    private Calendar expirationDate;
    private BigDecimal upperOperatingLimit;
    private BigDecimal emergencyUpperOperatingLimit;
    private BigDecimal startupCost;
    private List<SelfCommitment> selfCommitmentCurve;
    private List<EnergyCurvePoint> dispatchCurve;
    private BigDecimal fixedMinimumGenerationMw;
    private BigDecimal fixedMinimumGenerationCost;
    private BigDecimal tenMinNonSynchCost;
    private BigDecimal tenMinSpinCost;
    private BigDecimal thirtyMinNonSynchCost;
    private BigDecimal thirtyMinSpinCost;
    private BigDecimal regulationMw;
    private BigDecimal regulationCost;
    private BigDecimal regulationMovementCost;
    private BidStatus bidStatus;
    private List<GeneratorBidValidationMessage> bidValidationMessages;
    private GenBidScheduleType scheduleType;
    private List<GeneratorSchedule> genSchedules;
    private Calendar originalSubmissionTime;
    private Integer bidCopiedFrom;
    private FuelType fuelType;
    private BigDecimal fuelPrice;
    private BigDecimal hostLoadMw;
    private BigDecimal esrLowerOperatingLimit;
    private BigDecimal esrLowerStorageLimit;
    private BigDecimal esrUpperStorageLimit;
    private BigDecimal esrBeginningEnergyLevel;
    private EsrManagementMode esrManagementMode;
    private UnitOutageType esrOutageType;
    private List<BigDecimal> opportunityCostCurve;
    private BigDecimal csrInjectionLimit;
    private BigDecimal csrWithdrawalLimit;
    private UnitOutageType csrOutageType;

    public void addGenSchedule(GeneratorSchedule genSched) {
        if (this.genSchedules == null) {
            this.genSchedules = new ArrayList<GeneratorSchedule>(12);
        }
        this.genSchedules.add(genSched);
    }

    public Integer getBidId() {
        return this.bidId;
    }

    public void setBidId(Integer bidId) {
        this.bidId = bidId;
    }

    public Integer getBidDuration() {
        return this.bidDuration;
    }

    public void setBidDuration(Integer bidDuration) {
        this.bidDuration = bidDuration;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public BigDecimal getUpperOperatingLimit() {
        return this.upperOperatingLimit;
    }

    public void setUpperOperatingLimit(BigDecimal upperOperatingLimit) {
        this.upperOperatingLimit = upperOperatingLimit;
    }

    public BigDecimal getEmergencyUpperOperatingLimit() {
        return this.emergencyUpperOperatingLimit;
    }

    public void setEmergencyUpperOperatingLimit(BigDecimal emergencyUpperOperatingLimit) {
        this.emergencyUpperOperatingLimit = emergencyUpperOperatingLimit;
    }

    public BigDecimal getStartupCost() {
        return this.startupCost;
    }

    public void setStartupCost(BigDecimal startupCost) {
        this.startupCost = startupCost;
    }

    public List<SelfCommitment> getSelfCommitmentCurve() {
        return this.selfCommitmentCurve;
    }

    public void setSelfCommitmentCurve(List<SelfCommitment> selfCommitmentCurve) {
        this.selfCommitmentCurve = selfCommitmentCurve;
    }

    public List<EnergyCurvePoint> getDispatchCurve() {
        return this.dispatchCurve;
    }

    public void setDispatchCurve(List<EnergyCurvePoint> dispatchCurve) {
        this.dispatchCurve = dispatchCurve;
    }

    public BigDecimal getFixedMinimumGenerationMw() {
        return this.fixedMinimumGenerationMw;
    }

    public void setFixedMinimumGenerationMw(BigDecimal fixedMinimumGenerationMw) {
        this.fixedMinimumGenerationMw = fixedMinimumGenerationMw;
    }

    public BigDecimal getFixedMinimumGenerationCost() {
        return this.fixedMinimumGenerationCost;
    }

    public void setFixedMinimumGenerationCost(BigDecimal fixedMinimumGenerationCost) {
        this.fixedMinimumGenerationCost = fixedMinimumGenerationCost;
    }

    public BigDecimal getTenMinNonSynchCost() {
        return this.tenMinNonSynchCost;
    }

    public void setTenMinNonSynchCost(BigDecimal tenMinNonSynchCost) {
        this.tenMinNonSynchCost = tenMinNonSynchCost;
    }

    public BigDecimal getTenMinSpinCost() {
        return this.tenMinSpinCost;
    }

    public void setTenMinSpinCost(BigDecimal tenMinSpinCost) {
        this.tenMinSpinCost = tenMinSpinCost;
    }

    public BigDecimal getThirtyMinNonSynchCost() {
        return this.thirtyMinNonSynchCost;
    }

    public void setThirtyMinNonSynchCost(BigDecimal thirtyMinNonSynchCost) {
        this.thirtyMinNonSynchCost = thirtyMinNonSynchCost;
    }

    public BigDecimal getThirtyMinSpinCost() {
        return this.thirtyMinSpinCost;
    }

    public void setThirtyMinSpinCost(BigDecimal thirtyMinSpinCost) {
        this.thirtyMinSpinCost = thirtyMinSpinCost;
    }

    public BigDecimal getRegulationMw() {
        return this.regulationMw;
    }

    public void setRegulationMw(BigDecimal regulationMw) {
        this.regulationMw = regulationMw;
    }

    public BigDecimal getRegulationCost() {
        return this.regulationCost;
    }

    public void setRegulationCost(BigDecimal regulationCost) {
        this.regulationCost = regulationCost;
    }

    public BigDecimal getRegulationMovementCost() {
        return this.regulationMovementCost;
    }

    public void setRegulationMovementCost(BigDecimal regulationMovementCost) {
        this.regulationMovementCost = regulationMovementCost;
    }

    public BidStatus getBidStatus() {
        return this.bidStatus;
    }

    public void setBidStatus(BidStatus bidStatus) {
        this.bidStatus = bidStatus;
    }

    public BigDecimal getHostLoadMw() {
        return this.hostLoadMw;
    }

    public void setHostLoadMw(BigDecimal hostLoadMw) {
        this.hostLoadMw = hostLoadMw;
    }

    public List<GeneratorBidValidationMessage> getBidValidationMessages() {
        return this.bidValidationMessages;
    }

    public void setBidValidationMessages(List<GeneratorBidValidationMessage> bidValidationMessages) {
        this.bidValidationMessages = bidValidationMessages;
    }

    public void addValidationMessage(GeneratorBidValidationMessage message) {
        if (this.bidValidationMessages == null) {
            this.bidValidationMessages = new ArrayList<GeneratorBidValidationMessage>();
        }
        this.bidValidationMessages.add(message);
    }

    public void addValidationMessages(List<GeneratorBidValidationMessage> messages) {
        if (this.bidValidationMessages == null) {
            this.bidValidationMessages = new ArrayList<GeneratorBidValidationMessage>();
        }
        this.bidValidationMessages.addAll(messages);
    }

    public void clearValidationMessages() {
        if (this.bidValidationMessages != null) {
            this.bidValidationMessages.clear();
        }
    }

    public Calendar getBidDate() {
        return this.bidDate;
    }

    public void setBidDate(Calendar bidDate) {
        this.bidDate = bidDate;
    }

    public GeneratorBidMarket getGeneratorBidMarket() {
        return this.generatorBidMarket;
    }

    public void setGeneratorBidMarket(GeneratorBidMarket generatorBidMarket) {
        this.generatorBidMarket = generatorBidMarket;
    }

    public List<GeneratorSchedule> getGenSchedules() {
        return this.genSchedules;
    }

    public void setGenSchedules(List<GeneratorSchedule> genSchedules) {
        this.genSchedules = genSchedules;
    }

    public GenBidScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(GenBidScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public Calendar getOriginalSubmissionTime() {
        return this.originalSubmissionTime;
    }

    public void setOriginalSubmissionTime(Calendar originalSubmissionTime) {
        this.originalSubmissionTime = originalSubmissionTime;
    }

    public Integer getBidCopiedFrom() {
        return this.bidCopiedFrom;
    }

    public void setBidCopiedFrom(Integer bidCopiedFrom) {
        this.bidCopiedFrom = bidCopiedFrom;
    }

    public FuelType getFuelType() {
        return this.fuelType;
    }

    public void setFuelType(FuelType fuelType) {
        this.fuelType = fuelType;
    }

    public BigDecimal getFuelPrice() {
        return this.fuelPrice;
    }

    public void setFuelPrice(BigDecimal fuelPrice) {
        this.fuelPrice = fuelPrice;
    }

    public BigDecimal getEsrLowerOperatingLimit() {
        return this.esrLowerOperatingLimit;
    }

    public void setEsrLowerOperatingLimit(BigDecimal esrLowerOperatingLimit) {
        this.esrLowerOperatingLimit = esrLowerOperatingLimit;
    }

    public BigDecimal getEsrLowerStorageLimit() {
        return this.esrLowerStorageLimit;
    }

    public void setEsrLowerStorageLimit(BigDecimal esrLowerStorageLimit) {
        this.esrLowerStorageLimit = esrLowerStorageLimit;
    }

    public BigDecimal getEsrUpperStorageLimit() {
        return this.esrUpperStorageLimit;
    }

    public void setEsrUpperStorageLimit(BigDecimal esrUpperStorageLimit) {
        this.esrUpperStorageLimit = esrUpperStorageLimit;
    }

    public BigDecimal getEsrBeginningEnergyLevel() {
        return this.esrBeginningEnergyLevel;
    }

    public void setEsrBeginningEnergyLevel(BigDecimal esrBeginningEnergyLevel) {
        this.esrBeginningEnergyLevel = esrBeginningEnergyLevel;
    }

    public EsrManagementMode getEsrManagementMode() {
        return this.esrManagementMode;
    }

    public void setEsrManagementMode(EsrManagementMode esrManagementMode) {
        this.esrManagementMode = esrManagementMode;
    }

    public UnitOutageType getEsrOutageType() {
        return this.esrOutageType;
    }

    public void setEsrOutageType(UnitOutageType esrOutageType) {
        this.esrOutageType = esrOutageType;
    }

    public List<BigDecimal> getOpportunityCostCurve() {
        return this.opportunityCostCurve != null ? Collections.unmodifiableList(this.opportunityCostCurve) : null;
    }

    public void setOpportunityCostCurve(List<BigDecimal> opportunityCostCurve) {
        this.opportunityCostCurve = opportunityCostCurve != null ? Collections.unmodifiableList(opportunityCostCurve) : null;
    }

    public BigDecimal getCsrInjectionLimit() {
        return this.csrInjectionLimit;
    }

    public void setCsrInjectionLimit(BigDecimal csrInjectionLimit) {
        this.csrInjectionLimit = csrInjectionLimit;
    }

    public BigDecimal getCsrWithdrawalLimit() {
        return this.csrWithdrawalLimit;
    }

    public void setCsrWithdrawalLimit(BigDecimal csrWithdrawalLimit) {
        this.csrWithdrawalLimit = csrWithdrawalLimit;
    }

    public UnitOutageType getCsrOutageType() {
        return this.csrOutageType;
    }

    public void setCsrOutageType(UnitOutageType csrOutageType) {
        this.csrOutageType = csrOutageType;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("GeneratorBid clone failed.", cnse);
        }
    }
}

