/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.generator;

public enum GeneratorTypeEnum {
    CURTAILABLE_LOAD(12, "CURTAILABLE LOAD"),
    DSASP(0, "DSASP"),
    EXTERNAL(15, "EXTERNAL"),
    GROUP_UNIT(9, "GROUP UNIT"),
    LESR(16, "LESR"),
    NON_UTILITY_GENERATOR(2, "NON-UTILITY GENERATOR"),
    NORMAL_30_MINUTE_START(7, "NORMAL 30 MIN START"),
    NORMAL_QUICK_START(5, "NORMAL QUICK START"),
    PROXY(4, "PROXY"),
    SELF_SUPPLY_LOAD(13, "SELF SUPPLY LOAD"),
    STATION_SERVICE_GROUP(14, "STATION SERVICE GROUP"),
    SYNCH_CONDENSOR(3, "SYNCH CONDENSOR"),
    TRADING_HUB(17, "TRADING HUB"),
    UTILITY_GENERATOR(1, "UTILITY GENERATOR"),
    ESR(18, "ESR"),
    CSR_POI(19, "CSR POI");

    private int generatorTypeId;
    private String genTypeDescription;

    private GeneratorTypeEnum(int id, String description) {
        this.generatorTypeId = id;
        this.genTypeDescription = description;
    }

    public static GeneratorTypeEnum getGeneratorTypeFromDescription(String desc) {
        for (GeneratorTypeEnum genType : GeneratorTypeEnum.values()) {
            if (!genType.genTypeDescription.equals(desc)) continue;
            return genType;
        }
        throw new IllegalArgumentException("Unrecognized generator type: " + desc);
    }

    public static GeneratorTypeEnum getGeneratorTypeFromId(int generatorTypeId) {
        for (GeneratorTypeEnum generatorType : GeneratorTypeEnum.values()) {
            if (generatorType.getGeneratorTypeId() != generatorTypeId) continue;
            return generatorType;
        }
        throw new IllegalArgumentException("No generator type matching: " + generatorTypeId);
    }

    public int getGeneratorTypeId() {
        return this.generatorTypeId;
    }

    public String getGenTypeDescription() {
        return this.genTypeDescription;
    }
}

