/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.identity;

import com.nyiso.marketplace.businessobjects.bidding.bilateral.BilateralContract;
import com.nyiso.marketplace.businessobjects.generator.Generator;
import com.nyiso.marketplace.businessobjects.generator.GeneratorTypeEnum;
import com.nyiso.marketplace.businessobjects.identity.BillingOrganizationTrust;
import com.nyiso.marketplace.businessobjects.identity.GeneratorTrust;
import com.nyiso.marketplace.businessobjects.identity.LoadTrust;
import com.nyiso.marketplace.businessobjects.identity.Organization;
import com.nyiso.marketplace.businessobjects.identity.TrustType;
import com.nyiso.marketplace.businessobjects.load.Load;
import com.nyiso.marketplace.businessobjects.load.LoadType;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrustRelationships
implements Serializable {
    private static final Log LOG = LogFactory.getLog(TrustRelationships.class);
    private static final long serialVersionUID = 3996630321754197588L;
    private Organization trustedOrganization;
    private Map<Integer, BillingOrganizationTrust> orgLevelTrust;
    private Map<Integer, Map<Integer, GeneratorTrust>> generatorTrust;
    private Map<Integer, Map<Integer, LoadTrust>> loadTrust;

    public TrustRelationships(Organization trustedOrganization, Map<Integer, BillingOrganizationTrust> orgLevelTrust, Map<Integer, Map<Integer, GeneratorTrust>> generatorTrust, Map<Integer, Map<Integer, LoadTrust>> loadTrust) {
        this.trustedOrganization = trustedOrganization;
        this.orgLevelTrust = orgLevelTrust;
        this.generatorTrust = generatorTrust;
        this.loadTrust = loadTrust;
    }

    public boolean isTrustedByOrg(Organization trustingOrganization, TrustType trustType) {
        boolean isTrusted = false;
        if (trustingOrganization == null) {
            LOG.warn((Object)"TrustRelationships.isTrustedByOrg() called with null organization");
        } else if (trustingOrganization.getOrgId() != null && this.orgLevelTrust != null) {
            if (this.trustedOrganization != null && this.trustedOrganization.getOrgId().equals(trustingOrganization.getOrgId())) {
                return true;
            }
            BillingOrganizationTrust bot = this.orgLevelTrust.get(trustingOrganization.getOrgId());
            if (bot != null) {
                isTrusted = bot.getTrustTypes() != null ? bot.getTrustTypes().contains((Object)trustType) : false;
            }
        }
        return isTrusted;
    }

    public boolean isTrustedByGenerator(BilateralContract contract, TrustType trustType) {
        boolean isTrusted;
        block2: {
            GeneratorTrust genTrust;
            Map<Integer, GeneratorTrust> genTrusts;
            block3: {
                GeneratorTrust genTrust2;
                Generator trustingGen;
                block1: {
                    isTrusted = false;
                    if (contract != null && contract.getSource() != null) break block1;
                    LOG.warn((Object)"TrustRelationships.isTrustedByGenerator() called with null trusting Generator");
                    break block2;
                }
                if (contract.getSource().getPtid() == null || this.generatorTrust == null || (genTrusts = this.generatorTrust.get((trustingGen = contract.getSource()).getPtid())) == null || genTrusts.isEmpty()) break block2;
                if (!trustingGen.getGeneratorType().equals((Object)GeneratorTypeEnum.TRADING_HUB)) break block3;
                if (contract.getSourceEnergyOwnerOrg() == null || contract.getSourceEnergyOwnerOrg().getOrgId() == null || (genTrust2 = genTrusts.get(contract.getSourceEnergyOwnerOrg().getOrgId())) == null) break block2;
                isTrusted = genTrust2.getTrustTypes() != null ? genTrust2.getTrustTypes().contains((Object)trustType) : false;
                break block2;
            }
            Iterator<GeneratorTrust> iterator = genTrusts.values().iterator();
            while (iterator.hasNext() && !(isTrusted = (genTrust = iterator.next()).getTrustTypes() != null ? genTrust.getTrustTypes().contains((Object)trustType) : false)) {
            }
        }
        return isTrusted;
    }

    public boolean isTrustedByLoad(BilateralContract contract, TrustType trustType) {
        boolean isTrusted;
        block2: {
            LoadTrust ldTrust;
            Map<Integer, LoadTrust> loadTrusts;
            block3: {
                LoadTrust ldTrust2;
                Load trustingLoad;
                block1: {
                    isTrusted = false;
                    if (contract != null && contract.getSink() != null) break block1;
                    LOG.warn((Object)"TrustRelationships.isTrustedByLoad() called with null trusting Load");
                    break block2;
                }
                if (contract.getSink().getPtid() == null || this.loadTrust == null || (loadTrusts = this.loadTrust.get((trustingLoad = contract.getSink()).getPtid())) == null || loadTrusts.isEmpty()) break block2;
                if (!trustingLoad.getLoadType().equals((Object)LoadType.TRADING_HUB)) break block3;
                if (contract.getSinkEnergyOwnerOrg() == null || contract.getSinkEnergyOwnerOrg().getOrgId() == null || (ldTrust2 = loadTrusts.get(contract.getSinkEnergyOwnerOrg().getOrgId())) == null) break block2;
                isTrusted = ldTrust2.getTrustTypes() != null ? ldTrust2.getTrustTypes().contains((Object)trustType) : false;
                break block2;
            }
            Iterator<LoadTrust> iterator = loadTrusts.values().iterator();
            while (iterator.hasNext() && !(isTrusted = (ldTrust = iterator.next()).getTrustTypes() != null ? ldTrust.getTrustTypes().contains((Object)trustType) : false)) {
            }
        }
        return isTrusted;
    }

    public Map<Integer, Map<Integer, GeneratorTrust>> getGeneratorTrust() {
        return this.generatorTrust;
    }

    public Map<Integer, Map<Integer, LoadTrust>> getLoadTrust() {
        return this.loadTrust;
    }

    public Map<Integer, BillingOrganizationTrust> getOrgLevelTrust() {
        return this.orgLevelTrust;
    }

    public Organization getTrustedOrganization() {
        return this.trustedOrganization;
    }
}

