/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.businessobjects.load;

import com.nyiso.marketplace.businessobjects.load.LoadType;
import java.io.Serializable;
import java.util.Calendar;

public class LoadBase
implements Serializable {
    private static final long serialVersionUID = 471177798937203816L;
    private Integer loadId;
    private Integer ptid;
    private String loadName;
    private String stationName;
    private String voltageClass;
    private Boolean active;
    private Calendar lseBusStateDate;
    private Calendar lseBusEndDate;
    private LoadType loadType;

    public LoadBase() {
    }

    public LoadBase(Integer ptid) {
        this.ptid = ptid;
    }

    public LoadBase(Integer ptid, String stationName, String voltageClass, String loadName) {
        this.ptid = ptid;
        this.loadName = loadName;
        this.stationName = stationName;
        this.voltageClass = voltageClass;
    }

    public String getLoadName() {
        return this.loadName;
    }

    public void setLoadName(String loadName) {
        this.loadName = loadName;
    }

    public Integer getPtid() {
        return this.ptid;
    }

    public void setPtid(Integer ptid) {
        this.ptid = ptid;
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getVoltageClass() {
        return this.voltageClass;
    }

    public void setVoltageClass(String voltageClass) {
        this.voltageClass = voltageClass;
    }

    public String getDisplayName() {
        String loadNm;
        String stationNm = this.stationName != null ? this.stationName : "";
        String voltClass = this.voltageClass != null ? this.voltageClass : "";
        String string = loadNm = this.loadName != null ? this.loadName : "";
        if (stationNm.length() == 0 && voltClass.length() == 0 && loadNm.length() == 0) {
            return null;
        }
        return stationNm.concat("_").concat(voltClass).concat("_").concat(loadNm);
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Integer getLoadId() {
        return this.loadId;
    }

    public void setLoadId(Integer loadId) {
        this.loadId = loadId;
    }

    public Calendar getLseBusEndDate() {
        return this.lseBusEndDate;
    }

    public void setLseBusEndDate(Calendar lseBusEndDate) {
        this.lseBusEndDate = lseBusEndDate;
    }

    public Calendar getLseBusStateDate() {
        return this.lseBusStateDate;
    }

    public void setLseBusStateDate(Calendar lseBusStateDate) {
        this.lseBusStateDate = lseBusStateDate;
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    public void setLoadType(LoadType loadType) {
        this.loadType = loadType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active == null ? 0 : this.active.hashCode());
        result = 31 * result + (this.loadId == null ? 0 : this.loadId.hashCode());
        result = 31 * result + (this.loadName == null ? 0 : this.loadName.hashCode());
        result = 31 * result + (this.loadType == null ? 0 : this.loadType.hashCode());
        result = 31 * result + (this.lseBusEndDate == null ? 0 : this.lseBusEndDate.hashCode());
        result = 31 * result + (this.lseBusStateDate == null ? 0 : this.lseBusStateDate.hashCode());
        result = 31 * result + (this.ptid == null ? 0 : this.ptid.hashCode());
        result = 31 * result + (this.stationName == null ? 0 : this.stationName.hashCode());
        result = 31 * result + (this.voltageClass == null ? 0 : this.voltageClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBase other = (LoadBase)obj;
        if (this.active == null ? other.active != null : !this.active.equals(other.active)) {
            return false;
        }
        if (this.loadId == null ? other.loadId != null : !this.loadId.equals(other.loadId)) {
            return false;
        }
        if (this.loadName == null ? other.loadName != null : !this.loadName.equals(other.loadName)) {
            return false;
        }
        if (this.loadType == null ? other.loadType != null : !this.loadType.equals((Object)other.loadType)) {
            return false;
        }
        if (this.lseBusEndDate == null ? other.lseBusEndDate != null : !this.lseBusEndDate.equals(other.lseBusEndDate)) {
            return false;
        }
        if (this.lseBusStateDate == null ? other.lseBusStateDate != null : !this.lseBusStateDate.equals(other.lseBusStateDate)) {
            return false;
        }
        if (this.ptid == null ? other.ptid != null : !this.ptid.equals(other.ptid)) {
            return false;
        }
        if (this.stationName == null ? other.stationName != null : !this.stationName.equals(other.stationName)) {
            return false;
        }
        return !(this.voltageClass == null ? other.voltageClass != null : !this.voltageClass.equals(other.voltageClass));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LoadBase [");
        if (this.loadId != null) {
            builder.append("loadId=").append(this.loadId).append(", ");
        }
        if (this.ptid != null) {
            builder.append("ptid=").append(this.ptid).append(", ");
        }
        if (this.loadName != null) {
            builder.append("loadName=").append(this.loadName).append(", ");
        }
        if (this.stationName != null) {
            builder.append("stationName=").append(this.stationName).append(", ");
        }
        if (this.voltageClass != null) {
            builder.append("voltageClass=").append(this.voltageClass).append(", ");
        }
        if (this.active != null) {
            builder.append("active=").append(this.active).append(", ");
        }
        if (this.lseBusStateDate != null) {
            builder.append("lseBusStateDate=").append(this.lseBusStateDate).append(", ");
        }
        if (this.lseBusEndDate != null) {
            builder.append("lseBusEndDate=").append(this.lseBusEndDate).append(", ");
        }
        if (this.loadType != null) {
            builder.append("loadType=").append((Object)this.loadType);
        }
        builder.append("[").append(super.toString()).append("]]");
        return builder.toString();
    }
}

