/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.config;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigurationLoader {
    private static final Log LOG = LogFactory.getLog(ConfigurationLoader.class);

    private ConfigurationLoader() {
    }

    public static PropertiesConfiguration loadPropertiesConfiguration(String configLocation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("configLocation: " + configLocation));
        }
        try {
            PropertiesConfiguration propsConfig = new PropertiesConfiguration(ConfigurationLoader.class.getResource(configLocation));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exiting ConfigurationLoader.loadPropertiedConfiguration()");
            }
            return propsConfig;
        }
        catch (ConfigurationException ce) {
            LOG.error((Object)"", (Throwable)ce);
            return null;
        }
    }

    public static XMLConfiguration loadXmlConfiguration(String configLocation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("configLocation: " + configLocation));
        }
        try {
            XMLConfiguration xmlConfig = new XMLConfiguration(ConfigurationLoader.class.getResource(configLocation));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exiting ConfigurationLoader.loadXmlConfiguration()");
            }
            return xmlConfig;
        }
        catch (ConfigurationException ce) {
            LOG.error((Object)"", (Throwable)ce);
            return null;
        }
    }
}

