/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.exception;

import com.nyiso.marketplace.common.config.ConfigurationLoader;
import com.nyiso.marketplace.common.config.MessageHelper;
import com.nyiso.marketplace.common.exception.MarketplaceError;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ErrorMessagesCommon
extends MessageHelper {
    private static final String CONFIG_FILE = "/errormessages/commonerrormessages.properties";
    private static final PropertiesConfiguration CONFIG = ConfigurationLoader.loadPropertiesConfiguration("/errormessages/commonerrormessages.properties");
    protected static final int PREFIX_INDEX = 0;
    protected static final int CODE_INDEX = 1;
    protected static final int MESSAGE_INDEX = 2;

    protected static MarketplaceError createErrorFromArray(String[] values) {
        return MarketplaceError.createError(values[0], Integer.valueOf(values[1]), values[2]);
    }

    public static MarketplaceError getGeneralDataAccessError(String errorMessage) {
        String[] values = CONFIG.getStringArray("data.access.error");
        values[2] = ErrorMessagesCommon.replaceMessageToken(values[2], errorMessage);
        return ErrorMessagesCommon.createErrorFromArray(values);
    }

    public static MarketplaceError createUnexpectedErrorMessage(String message) {
        String[] values = CONFIG.getStringArray("unexpected.error");
        values[2] = ErrorMessagesCommon.replaceMessageToken(values[2], message);
        return ErrorMessagesCommon.createErrorFromArray(values);
    }

    public static MarketplaceError getUserNotAuthSubmitUnitCommitmentDataMessage() {
        String[] values = CONFIG.getStringArray("user.not.auth.submit.uc.data");
        return ErrorMessagesCommon.createErrorFromArray(values);
    }

    public static MarketplaceError getUserNotAuthInsertGeneratorLimitsMessage() {
        String[] values = CONFIG.getStringArray("user.not.auth.insert.generator.limits");
        return ErrorMessagesCommon.createErrorFromArray(values);
    }

    public static MarketplaceError getUserNotLoggedInMessage() {
        String[] values = CONFIG.getStringArray("user.not.logged.in");
        return ErrorMessagesCommon.createErrorFromArray(values);
    }

    public static String getCsrfErrorMessage() {
        String[] values = CONFIG.getStringArray("csrf.error.message");
        return ErrorMessagesCommon.createErrorFromArray(values).getUserMessage();
    }

    public static MarketplaceError getStartupCostBidTreatmentEffectiveDateNotAvailableMessage() {
        String[] values = CONFIG.getStringArray("startup.cost.bid.treatment.effective.date.notset");
        return ErrorMessagesCommon.createErrorFromArray(values);
    }
}

