/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.map.keys;

import com.nyiso.marketplace.businessobjects.bidding.Market;
import java.io.Serializable;
import java.util.Calendar;

public class BilateralBidMapKey
implements Serializable {
    private static final long serialVersionUID = 2757636553382407114L;
    private Long contractId;
    private long bidDateTimeInMillis;
    private Market market;
    private int hash;

    public BilateralBidMapKey(Long contractId, Calendar bidDateTime, Market market) {
        this.bidDateTimeInMillis = bidDateTime.getTimeInMillis();
        this.contractId = contractId;
        this.market = market;
        this.hash = this.calculateHash();
    }

    public int hashCode() {
        return this.hash;
    }

    private int calculateHash() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bidDateTimeInMillis ^ this.bidDateTimeInMillis >>> 32);
        result = 31 * result + (this.contractId == null ? 0 : this.contractId.hashCode());
        result = 31 * result + (this.market == null ? 0 : this.market.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BilateralBidMapKey other = (BilateralBidMapKey)obj;
        if (this.bidDateTimeInMillis != other.bidDateTimeInMillis) {
            return false;
        }
        if (this.contractId == null ? other.contractId != null : !this.contractId.equals(other.contractId)) {
            return false;
        }
        return !(this.market == null ? other.market != null : !this.market.equals((Object)other.market));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BilateralBidMapKey [");
        if (this.contractId != null) {
            builder.append("contractId=").append(this.contractId).append(", ");
        }
        builder.append("bidDateTimeInMillis=").append(this.bidDateTimeInMillis).append(", ");
        if (this.market != null) {
            builder.append("market=").append((Object)this.market).append(", ");
        }
        builder.append("hash=").append(this.hash).append("[").append(super.toString()).append("]]");
        return builder.toString();
    }
}

