/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.map.keys;

import com.nyiso.marketplace.businessobjects.bidding.generator.GeneratorBid;
import com.nyiso.marketplace.businessobjects.bidding.generator.GeneratorBidMarket;
import java.io.Serializable;
import java.util.Calendar;

public class GeneratorBidMapKey
implements Serializable {
    private static final long serialVersionUID = -8121408424632077960L;
    private Integer generatorId;
    private long bidDateTimeInMillis;
    private GeneratorBidMarket generatorBidMarket;
    private int hash;

    public GeneratorBidMapKey(GeneratorBid generatorBid) {
        this(generatorBid.getGenerator().getGeneratorId(), generatorBid.getBidDate(), generatorBid.getGeneratorBidMarket());
    }

    public GeneratorBidMapKey(Integer generatorId, Calendar bidDateTime, GeneratorBidMarket generatorBidMarket) {
        this.bidDateTimeInMillis = bidDateTime.getTimeInMillis();
        this.generatorId = generatorId;
        this.generatorBidMarket = generatorBidMarket;
        this.hash = this.calculateHash();
    }

    public int hashCode() {
        return this.hash;
    }

    private int calculateHash() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bidDateTimeInMillis ^ this.bidDateTimeInMillis >>> 32);
        result = 31 * result + (this.generatorId == null ? 0 : this.generatorId.hashCode());
        result = 31 * result + (this.generatorBidMarket == null ? 0 : this.generatorBidMarket.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneratorBidMapKey other = (GeneratorBidMapKey)obj;
        if (this.bidDateTimeInMillis != other.bidDateTimeInMillis) {
            return false;
        }
        if (this.generatorId == null ? other.generatorId != null : !this.generatorId.equals(other.generatorId)) {
            return false;
        }
        return !(this.generatorBidMarket == null ? other.generatorBidMarket != null : !this.generatorBidMarket.equals((Object)other.generatorBidMarket));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratorBidMapKey [");
        if (this.generatorId != null) {
            builder.append("generatorId=").append(this.generatorId).append(", ");
        }
        builder.append("bidDateTimeInMillis=").append(this.bidDateTimeInMillis).append(", ");
        if (this.generatorBidMarket != null) {
            builder.append("generatorBidMarket=").append((Object)this.generatorBidMarket).append(", ");
        }
        builder.append("hash=").append(this.hash).append("[").append(super.toString()).append("]]");
        return builder.toString();
    }
}

