/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.util;

import com.nyiso.marketplace.common.util.HourInDay;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class DateUtilities {
    public static final TimeZone EASTERN_TIME_ZONE = TimeZone.getTimeZone("America/New_York");
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    protected static final int GMT_OFF_SET = -18000000;
    public static final String SLASH = "/";
    public static final String ERA = "G";
    public static final String YEAR = "y";
    public static final String MONTH_IN_YEAR = "M";
    public static final String WEEK_IN_YEAR = "w";
    public static final String WEEK_IN_MONTH = "W";
    public static final String DAY_IN_YEAR = "D";
    public static final String DAY_IN_MONTH = "d";
    public static final String DAY_OF_WEEK_IN_MONTH = "F";
    public static final String DAY_IN_WEEK = "E";
    public static final String AM_PM_MARKET = "a";
    public static final String HOUR_IN_DAY_MILITARY_ZERO_START = "H";
    public static final String HOUR_IN_DAY_MILITARY_ONE_START = "k";
    public static final String HOUR_IN_DAY_ZERO_START = "K";
    public static final String HOUR_IN_DAY_ONE_START = "h";
    public static final String MINUTE_IN_HOUR = "m";
    public static final String SECOND_IN_MINUTE = "s";
    public static final String MILLISECOND = "S";
    public static final String TIME_ZONE = "z";
    public static final String TIME_ZONE_OFFSET = "Z";
    public static final String SHORT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String DATE_TIME_PATTERN = "MM/dd/yyyy HH:mm";
    public static final String DATE_TIME_TIMEZONE_FORMAT = "MM/dd/yyyy HH:mm z";
    public static final String LONG_DATE_TIME_PATTERN = "MM/dd/yyyy HH:mm:ss";
    public static final String LONG_DATE_TIME_TIMEZONE_FORMAT = "MM/dd/yyyy HH:mm:ss z";
    public static final String HOUR_MINUTE_PATTERN = "HH:mm";
    public static final String HOUR_MINUTE_TZ_PATTERN = "HH:mm z";
    protected static final SimpleTimeZone STZ_2006 = new SimpleTimeZone(-18000000, "America/New_York", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000);
    protected static final SimpleTimeZone STZ_2007 = new SimpleTimeZone(-18000000, "America/New_York", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00, 3600000);
    private static final BigDecimal MILLISECONDS_TO_DAYS_FACTOR = new BigDecimal(86400000);

    private DateUtilities() {
    }

    public static BigDecimal daysBetweenDates(Calendar startDate, boolean startDateInclusive, Calendar endDate, boolean endDateInclusive) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate.getTime());
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate.getTime());
        if (!startDateInclusive) {
            startCal.add(5, 1);
        }
        if (!endDateInclusive) {
            endCal.add(5, -1);
        }
        long startTimeMillis = startCal.getTimeInMillis();
        long endTimeMillis = endCal.getTimeInMillis();
        BigDecimal timeDiff = new BigDecimal(endTimeMillis - startTimeMillis);
        BigDecimal days = timeDiff.divide(MILLISECONDS_TO_DAYS_FACTOR, 4, RoundingMode.UP);
        return days;
    }

    public static Calendar convertDateStringToCalendar(String dateString, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateFormat.parse(dateString));
        return cal;
    }

    public static String convertCalendarToString(Calendar cal, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(cal.getTime());
    }

    public static Calendar setCalendarToHourZero(Calendar baseCal) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseCal.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Calendar returnCal = Calendar.getInstance();
        returnCal.setTime(cal.getTime());
        return returnCal;
    }

    public static Calendar setGmtCalendarToEstHourZero(Calendar baseCal) throws ParseException {
        Calendar cal = DateUtilities.convertGmtCalendarToEstCalendar(baseCal, DATE_TIME_PATTERN);
        cal = DateUtilities.setCalendarToHourZero(cal);
        cal = DateUtilities.convertEstCalendarToGmtCalendar(cal, DATE_TIME_PATTERN);
        return cal;
    }

    public static int numHoursInDateLocal(Calendar cal) {
        Calendar calZero = Calendar.getInstance();
        calZero.setTimeInMillis(cal.getTimeInMillis());
        calZero.set(11, 7);
        int date = calZero.get(5);
        SimpleTimeZone stz = null;
        stz = cal.get(1) <= 2006 ? STZ_2006 : STZ_2007;
        boolean calZeroInDst = stz.inDaylightTime(calZero.getTime());
        Calendar calMinusOne = Calendar.getInstance();
        calMinusOne.setTime(calZero.getTime());
        calMinusOne.set(5, date - 1);
        boolean calMinusOneInDst = stz.inDaylightTime(calMinusOne.getTime());
        if (calZeroInDst && !calMinusOneInDst) {
            return 23;
        }
        if (!calZeroInDst && calMinusOneInDst) {
            return 25;
        }
        return 24;
    }

    public static int numHoursInDateGMT(Calendar cal) throws ParseException {
        Calendar localCal = DateUtilities.convertGmtCalendarToEstCalendar(cal, DATE_TIME_PATTERN);
        return DateUtilities.numHoursInDateLocal(localCal);
    }

    public static String convertEstStringToGmtString(String dateString, String patternIn, String patternOut) throws ParseException {
        SimpleDateFormat dateFormatterIn = new SimpleDateFormat(patternIn);
        dateFormatterIn.setLenient(false);
        dateFormatterIn.setTimeZone(EASTERN_TIME_ZONE);
        SimpleDateFormat dateFormatterOut = new SimpleDateFormat(patternOut);
        dateFormatterOut.setTimeZone(GMT_TIME_ZONE);
        Date estDate = dateFormatterIn.parse(dateString);
        return dateFormatterOut.format(estDate);
    }

    public static String convertGmtStringToEstString(String dateString, String patternIn, String patternOut) throws ParseException {
        SimpleDateFormat dateFormatterIn = new SimpleDateFormat(patternIn);
        dateFormatterIn.setLenient(false);
        dateFormatterIn.setTimeZone(GMT_TIME_ZONE);
        SimpleDateFormat dateFormatterOut = new SimpleDateFormat(patternOut);
        dateFormatterOut.setTimeZone(EASTERN_TIME_ZONE);
        Date gmtDate = dateFormatterIn.parse(dateString);
        return dateFormatterOut.format(gmtDate);
    }

    public static Calendar convertEstCalendarToGmtCalendar(Calendar estCal, String patternIn) throws ParseException {
        Calendar result = null;
        String calString = DateUtilities.convertCalendarToString(estCal, patternIn);
        String gmtString = DateUtilities.convertEstStringToGmtString(calString, patternIn, patternIn);
        result = DateUtilities.convertDateStringToCalendar(gmtString, patternIn);
        return result;
    }

    public static Calendar convertGmtCalendarToEstCalendar(Calendar gmtCal, String patternIn) throws ParseException {
        Calendar result = null;
        String calString = DateUtilities.convertCalendarToString(gmtCal, patternIn);
        String estString = DateUtilities.convertGmtStringToEstString(calString, patternIn, patternIn);
        result = DateUtilities.convertDateStringToCalendar(estString, patternIn);
        return result;
    }

    public static String convertGmtCalendarToEstString(Calendar gmtCalendar) throws ParseException {
        String dateGmt = DateUtilities.convertCalendarToString(gmtCalendar, DATE_TIME_PATTERN);
        return DateUtilities.convertGmtStringToEstString(dateGmt, DATE_TIME_PATTERN, DATE_TIME_PATTERN);
    }

    public static List<HourInDay> getHoursInDateLocalTime(Calendar date) {
        int numHours = DateUtilities.numHoursInDateLocal(date);
        ArrayList<HourInDay> hours = new ArrayList<HourInDay>(numHours);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.setTimeZone(EASTERN_TIME_ZONE);
        SimpleDateFormat dateFormat = new SimpleDateFormat(HOUR_MINUTE_TZ_PATTERN);
        dateFormat.setTimeZone(EASTERN_TIME_ZONE);
        for (int i = 0; i < numHours; ++i) {
            HourInDay hour = new HourInDay(dateFormat.format(cal.getTime()));
            hours.add(hour);
            cal.add(11, 1);
        }
        return hours;
    }

    public static Calendar addOneDay(Calendar startDateTime) {
        Calendar endDateTime = null;
        endDateTime = (Calendar)startDateTime.clone();
        endDateTime.add(6, 1);
        SimpleTimeZone stz = null;
        stz = startDateTime.get(1) <= 2006 ? STZ_2006 : STZ_2007;
        boolean calStartTimeInDst = stz.inDaylightTime(startDateTime.getTime());
        boolean calEndTimeInDst = stz.inDaylightTime(endDateTime.getTime());
        if (calStartTimeInDst && !calEndTimeInDst) {
            endDateTime.add(10, 1);
        } else if (!calStartTimeInDst && calEndTimeInDst) {
            endDateTime.add(10, -1);
        }
        return endDateTime;
    }

    public static Calendar convertEstStringToGmtCal(String value) throws ParseException {
        Calendar cal;
        if (value.endsWith("EST") || value.endsWith("EDT")) {
            cal = DateUtilities.convertDateStringToCalendar(value, DATE_TIME_TIMEZONE_FORMAT);
        } else {
            String gmtString = DateUtilities.convertEstStringToGmtString(value, DATE_TIME_PATTERN, DATE_TIME_PATTERN);
            cal = DateUtilities.convertDateStringToCalendar(gmtString, DATE_TIME_PATTERN);
        }
        return cal;
    }

    public static Calendar convertEstStringToGmtCalWithSeconds(String value) throws ParseException {
        Calendar cal;
        if (value.endsWith("EST") || value.endsWith("EDT")) {
            cal = DateUtilities.convertDateStringToCalendar(value, LONG_DATE_TIME_TIMEZONE_FORMAT);
        } else {
            String gmtString = DateUtilities.convertEstStringToGmtString(value, LONG_DATE_TIME_PATTERN, LONG_DATE_TIME_PATTERN);
            cal = DateUtilities.convertDateStringToCalendar(gmtString, LONG_DATE_TIME_PATTERN);
        }
        return cal;
    }
}

