/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.util;

import com.nyiso.marketplace.businessobjects.bidding.generator.GeneratorBid;
import com.nyiso.marketplace.businessobjects.generator.Generator;
import com.nyiso.marketplace.businessobjects.generator.GeneratorBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class GeneratorUtil {
    private static final GeneratorBase NYISO_REFERENCE_GENERATOR = new GeneratorBase(24008, "NYISO", "LBMP", "REFERENCE");

    private GeneratorUtil() {
    }

    public static boolean isGeneratorUniquelyIdentified(GeneratorBase genBase) {
        if (genBase == null) {
            return false;
        }
        return genBase.getPtid() != null || genBase.getDisplayName() != null;
    }

    public static boolean isNyisoReferenceGenerator(GeneratorBase genBase) {
        if (genBase == null) {
            return false;
        }
        if (genBase.getPtid() != null && genBase.getPtid().intValue() == NYISO_REFERENCE_GENERATOR.getPtid().intValue()) {
            return true;
        }
        return genBase.getDisplayName() != null && genBase.getDisplayName().equals(NYISO_REFERENCE_GENERATOR.getDisplayName());
    }

    public static List<Generator> getGeneratorsFromGenBids(List<GeneratorBid> generatorBids) {
        ArrayList generatorList = null;
        if (generatorBids != null && generatorBids.size() > 0) {
            HashMap<Integer, Generator> generatorMap = new HashMap<Integer, Generator>();
            for (GeneratorBid generatorBid : generatorBids) {
                generatorMap.put(generatorBid.getGenerator().getPtid(), generatorBid.getGenerator());
            }
            generatorList = new ArrayList();
            generatorList.addAll(generatorMap.values());
        }
        return generatorList;
    }
}

