/*
 * Decompiled with CFR 0.152.
 */
package com.nyiso.marketplace.common.util;

import com.nyiso.marketplace.common.util.DateUtilities;
import java.text.ParseException;
import java.util.Calendar;

public final class MarketCloseHelper {
    private static final int HAM_CLOSE_MINUTES_OFFSET = -75;
    private static final int DAM_CLOSE_HOURS_OFFSET = -19;

    private MarketCloseHelper() {
    }

    public static Calendar getDamMarketCloseInGmt(Calendar bidDateTime) throws ParseException {
        Calendar damClose = Calendar.getInstance();
        damClose.setTime(bidDateTime.getTime());
        damClose = DateUtilities.convertGmtCalendarToEstCalendar(damClose, "MM/dd/yyyy HH:mm");
        damClose = DateUtilities.setCalendarToHourZero(damClose);
        damClose.add(11, -19);
        damClose = DateUtilities.convertEstCalendarToGmtCalendar(damClose, "MM/dd/yyyy HH:mm");
        return damClose;
    }

    public static Calendar getHamMarketClose(Calendar bidDateTime) {
        Calendar hamClose = Calendar.getInstance();
        hamClose.setTime(bidDateTime.getTime());
        hamClose.set(12, 0);
        hamClose.set(13, 0);
        hamClose.set(14, 0);
        hamClose.add(12, -75);
        return hamClose;
    }
}

